<?php
session_start();
$date=explode('-',date("Y-m-d", strtotime("last day of previous month")));
$month=$date[1];
$year=$date[0];

$monthNum  =$month;
$dateObj   = DateTime::createFromFormat('!m', $monthNum);
$monthName = strtoupper($dateObj->format('F'));

// CONNECT TO DATABASE
// ! CHANGE THESE SETTINGS TO YOUR OWN !
      require_once '../system/conn.php';


$query=$conn->prepare("SELECT name FROM branch WHERE id=:param");
$query->bindParam(':param', $_SESSION['branch']);
$query->execute();
$result = $query -> fetch(PDO::FETCH_ASSOC);
$br=$result['name'];

// CREATE PHPSPREADSHEET OBJECT
require "excel_test/vendor/autoload.php";
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// CREATE A NEW SPREADSHEET + POPULATE DATA
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();
$spreadsheet->getActiveSheet()->mergeCells('A1:O1');
$spreadsheet->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('L')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('M')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('N')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('O')->setAutoSize(true);




$styleArray = [
    'font' => [
        'bold' => true,
    ],
    'alignment' => [
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
    ],
    'fill' => [
        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_GRADIENT_LINEAR,
        'rotation' => 90,
        'startColor' => [
            'argb' => 'FFA0A0A0',
        ],
        'endColor' => [
            'argb' => 'FFFFFFFF',
        ],
    ],
];
$styleArray1 = [
    'font' => [
        'bold' => true,
    ],
    'alignment' => [
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
    ],
];

$spreadsheet->getActiveSheet()->getStyle('A3:O3')->applyFromArray($styleArray1);
$spreadsheet->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);



$sheet->setTitle('Left Employee sheet');
$stmt = $conn->prepare(" SELECT emp_details.`sn`,emp_details.`e_id`,emp_details.`branch`,emp_details.`e_name`,emp_details.`fname`,emp_details.`mobile_num`,emp_details.`aadhar_num`,emp_details.`pan_card`,emp_details.`designation`,emp_details.`salary`,emp_details.`bank_ac_no`,left_employee.d_o_l,left_employee.entry_date,left_employee.id FROM emp_details LEFT JOIN left_employee ON emp_details.`e_id`=left_employee.emp_id AND emp_details.branch=left_employee.branch WHERE emp_details.status='0' and left_employee.status='1' ");
    
$stmt->execute();
$a = 1;
$i = 4;
  $sheet->setCellValue('A1', 'LEFT EMPLOYEES SHEET AS ON '.$monthName.' '. $year);
  $sheet->setCellValue('A3', 'SR NO');
  $sheet->setCellValue('B3', 'EID');
  $sheet->setCellValue('C3', 'LEFT DATE');
  $sheet->setCellValue('D3', 'NAME');
  $sheet->setCellValue('E3', 'DESIGNATION');
  $sheet->setCellValue('F3', 'FATHER NAME');
  $sheet->setCellValue('G3', 'JOINING DATE');
  $sheet->setCellValue('H3', 'BIRTH DATE');
  $sheet->setCellValue('I3', 'MOBILE');
  $sheet->setCellValue('J3', 'AADHAR');
  $sheet->setCellValue('K3', 'PAN');
  $sheet->setCellValue('L3', 'SALARY');
  $sheet->setCellValue('M3', 'ACCOUNT');
  $sheet->setCellValue('N3', 'ADDRESS');
  $sheet->setCellValue('O3', 'BRANCH');
  
  
   
while ($row = $stmt->fetch(PDO::FETCH_NAMED)) {
  $sheet->setCellValue('A'.$i, $a);
  $sheet->setCellValue('B'.$i, $row['e_id']);
  $sheet->setCellValue('C'.$i, $row['d_o_l']);
  $sheet->setCellValue('D'.$i, $row['e_name']);
  $sheet->setCellValue('E'.$i, $row['designation']);
  $sheet->setCellValue('F'.$i, $row['fname']);
  $sheet->setCellValue('G'.$i, $row['e_doj']);
  $sheet->setCellValue('H'.$i, $row['dob']);
  $sheet->setCellValue('I'.$i, $row['mobile_num']);
  $sheet->setCellValue('J'.$i, ' '.$row['aadhar_num']);
  $sheet->setCellValue('K'.$i, ' '.$row['pan_card']);
  $sheet->setCellValue('L'.$i, $row['salary']);
  $sheet->setCellValue('M'.$i, ' '.$row['bank_ac_no']);
  $sheet->setCellValue('N'.$i, $row['addr']);

  $stmt1 = $conn->prepare("SELECT `name`  from branch WHERE `id`='".$row['branch']."' ");
  $stmt1->execute();
  while ($row1 = $stmt1->fetch(PDO::FETCH_NAMED)) {
    $sheet->setCellValue('O'.$i, $row1['name']);
  }
  $i++;
  $a++;
}

$spreadsheet->getActiveSheet()->getStyle('A'.$i.':O'.$i)->applyFromArray($styleArray1);


// OUTPUT
$writer = new Xlsx($spreadsheet);
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="Left-Employees(Admin).xlsx"');
header('Cache-Control: max-age=0');
header('Expires: Fri, 11 Nov 2011 11:11:11 GMT');
header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
header('Cache-Control: cache, must-revalidate');
header('Pragma: public');
$writer->save('php://output');
?>