<?php 
    session_start();
    if(!$_SESSION['id']){
        header('location:index.php');
    }
      require_once '../system/conn.php';
?>
<!doctype html>
<html lang="en" class="semi-dark">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
	<link href="assets/css/pace.min.css" rel="stylesheet" />
	<script src="assets/js/pace.min.js"></script>
    <link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
    <link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
    <link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
    <link href="assets/plugins/datatable/css/dataTables.bootstrap5.min.css" rel="stylesheet" />
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/bootstrap-extended.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
    <link href="assets/css/icons.css" rel="stylesheet">
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    <link href="assets/css/dark-theme.css" rel="stylesheet" />
    <link href="assets/css/semi-dark.css" rel="stylesheet" />
    <link href="assets/css/header-colors.css" rel="stylesheet" />
    <title>All Candidates List</title>
  </head>
  <body>
    <div class="wrapper">
    <?php include'system/header.php'?>
	    <div class="page-content-wrapper">
         <div class="page-content">
          <!--start breadcrumb-->
          <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">All Candidates List</div>
            <div class="ms-auto">
              <a href="add-candidate.php"><button type="button" class="btn btn-success px-5">Add New Candidate</button></a>
              <!-- <a href="excel-employee.php"><button type="button" class="btn btn-primary px-5">Excel Download</button></a> -->
            </div>
          </div>
		  <hr/>
		  <div class="card">
			<div class="card-body">
			  <div class="table-responsive">
				 <table id="example2" class="table table-striped table-bordered">
					<thead>
					    <tr>
							<th>SR No</th>
    						<th>Id No</th>
                            <th>Photo</th>
                            <th>Name</th>
                            <th>Post Applied</th>
                            <th>Date of Application</th>
                            <th>Experience(Yr)</th>
                            <th>Convert to Employee</th>
                            <th>Mobile Number</th>
                            <th>Dob</th>
                            <th>Action</th>
						</tr>
					</thead>
					<tbody>
					<?php 
                      $cnt = 1;
                      $stmt1 = $conn->prepare("SELECT * FROM `candidate_details` ORDER BY id DESC");
                      $stmt1->execute();
                      $sql = $stmt1->fetchAll();
                      foreach($sql as $row2) 
                      { 
                    ?>
                        <tr>
                            <td><?php echo $cnt;?></td>
                            <td>
                                <a href="view-details-all-candidate.php?id=<?php echo $row2['candidate_id'];?>"><?php echo $row2['candidate_id'];?></a>
                            </td>
                            <td>
                            <img src="../assets/images/candidates/<?php echo $row2['photo'] ? $row2['photo'] : 'dummy-user.webp'; ?>" class="img-thumbnail" alt="No image" style="width:60px"><br>
                            <a href="edit-candidate-image.php?id=<?php echo $row2['id'];?>" class="invoice-action-edit">
                                    <i class="bi bi-pencil-square"></i>
                            </a>
                          </td>
                            </td>
                            <td><?php echo $row2['full_name'];?></td>
                            <td><?php echo $row2['desired_position'];?></td>
                            <td><?php echo $row2['date_of_application'];?></td>
                            <td><?php echo $row2['experience'];?></td>
                            
                            <td>
<?php if ($row2['convert_status'] == 0) { ?>
    <a href="covert-to-emp.php?id=<?php echo $row2['id']; ?>" class="badge bg-dark text-white">
        Convert <i class="bi bi-shuffle"></i>
    </a>
<?php } else { ?>
    <span class="badge bg-success text-white">
        Converted <i class="bi bi-check-circle"></i>
    </span>
<?php } ?>
</td>

                            <td><?php echo $row2['phone_number'];?></td>
                            <td><?php echo $row2['date_of_birth'];?></td>
                            <td>
                                <div class="invoice-action">
                                  <a href="view-candidate-details.php?id=<?php echo $row2['id'];?>" class="invoice-action-view mr-4">
                                    <i class="lni lni-eye"></i>
                                  </a>
                                  <a href="edit-candidate.php?id=<?php echo $row2['id'];?>" class="invoice-action-edit">
                                    <i class="bi bi-pencil-square"></i>
                                  </a>
                                  <a href="delete-candidate.php?id=<?php echo $row2['id'];?>" onclick="return confirm('Are you want to delete this record ?')" class="invoice-action-view mr-4" >
                                    <i class="lni lni-trash"></i>
                                  </a>
                                </div>
                            </td>
                        </tr>
                    <?php  $cnt=$cnt+1; }?>
					</tbody>
					<tfoot>
                    <tr>
							<th>SR No</th>
    						<th>Id No</th>
                            <th>Photo</th>
                            <th>Name</th>
                            <th>Post Applied</th>
                            <th>Date of Application</th>
                            <th>Experience</th>
                            <th>Convert to Employee</th>
                            <th>Mobile Number</th>
                            <th>Dob</th>
                            <th>Action</th>
						</tr>
					</tfoot>
				</table>
			</div>
		</div>
	</div>
             
          </div>
          <!-- end page content-->
         </div>
<?php include 'system/footer.php'?>