<?php
    session_start();
    if(!$_SESSION['id']){
        header('location:index.php');
    }
  require_once '../system/conn.php';
?>

<!doctype html>

<html lang="en" class="semi-dark">



<head>

    <meta charset="utf-8">

    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link href="assets/css/pace.min.css" rel="stylesheet" />

    <script src="assets/js/pace.min.js"></script>

    <link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />

    <link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />

    <link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />

    <link href="assets/plugins/datatable/css/dataTables.bootstrap5.min.css" rel="stylesheet" />

    <link href="assets/css/bootstrap.min.css" rel="stylesheet">

    <link href="assets/css/bootstrap-extended.css" rel="stylesheet">

    <link href="assets/css/style.css" rel="stylesheet">

    <link href="assets/css/icons.css" rel="stylesheet">

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css">

    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">

    <link href="assets/css/dark-theme.css" rel="stylesheet" />

    <link href="assets/css/semi-dark.css" rel="stylesheet" />

    <link href="assets/css/header-colors.css" rel="stylesheet" />

    <title>All Employees List</title>

</head>



<body>

    <div class="wrapper">

        <?php include'system/header.php'?>

        <div class="page-content-wrapper">

            <div class="page-content">

                <!--start breadcrumb-->

                <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">

                    <div class="breadcrumb-title pe-3">All Employees List</div>

                    <div class="ms-auto">

                        <a href="add-employee.php"><button type="button" class="btn btn-success px-5">Add New

                                Employee</button></a>

                        <a href="excel-employee.php"><button type="button" class="btn btn-primary px-5">Excel

                                Download</button></a>

                    </div>

                </div>

                <hr />

                <div class="card">

                    <div class="card-body">

                        <div class="table-responsive">

                            <table id="example2" class="table table-striped table-bordered">

                                <thead>

                                    <tr>

                                        <th>SR No</th>

                                        <th>Id No</th>

                                        <th>Branch</th>

                                        <!--<th>Photo</th>-->

                                        <th>Employee Name</th>

                                        <th>Father Name</th>

                                        <th>Designation</th>

                                        <th>Mobile Number</th>

                                        <th>OT</th>

                                        <th>PF</th>

                                        <th>ESIC</th>

                                        <th>Dob</th>

                                        <th>EMP Docs</th>

                                        <th>Doj</th>

                                        <th>Salary</th>

                                        <th>UAN Number</th>

                                        <th>Bank Account Number</th>

                                        <th>ESIC Number</th>

                                        <th>Action</th>

                                    </tr>

                                </thead>

                                <tbody>
<?php
$cnt = 1;

$stmt = $conn->prepare("
    SELECT 
        e.*,
        b.name AS branch_name
    FROM emp_details e
    LEFT JOIN branch b 
        ON e.branch = b.id
    WHERE e.status = 1
    ORDER BY e.e_name ASC
");

$stmt->execute();
$employees = $stmt->fetchAll(PDO::FETCH_ASSOC);

foreach ($employees as $row2) {
?>
<tr>
    <td><?= $cnt++; ?></td>

    <td>
        <a href="view-details-all-emp.php?id=<?= $row2['sn']; ?>">
            <?= htmlspecialchars($row2['e_id']); ?>
        </a>
    </td>

    <td><?= htmlspecialchars($row2['branch_name']); ?></td>

    <!--<td>-->
    <!--    <img src="../assets/images/employee/
    <?
    // = $row2['image'] ?: 'dummy-user.webp'; 
    ?>
    "-->
    <!--         class="img-thumbnail" alt="No image" style="width:60px"><br>-->

    <!--    <a href="edit-employee-photo.php?id=
    <?
    // = $row2['e_id']; 
    ?>
    " class="invoice-action-edit">-->
    <!--        <i class="bi bi-pencil-square"></i>-->
    <!--    </a>-->
    <!--</td>-->

    <td><?= htmlspecialchars($row2['e_name']); ?></td>
    <td><?= htmlspecialchars($row2['fname']); ?></td>
    <td><?= htmlspecialchars($row2['designation']); ?></td>
    <td><?= htmlspecialchars($row2['mobile_num']); ?></td>
    <td><?= htmlspecialchars($row2['ot']); ?></td>
    <td><?= htmlspecialchars($row2['pf']); ?></td>
    <td><?= htmlspecialchars($row2['esi']); ?></td>
    <td><?= htmlspecialchars($row2['dob']); ?></td>

    <td>
        <div class="dropdown">
            <button class="badge bg-primary dropdown-toggle" type="button"
                data-bs-toggle="dropdown">
                Select Document
            </button>
            <ul class="dropdown-menu">
                <li><a class="dropdown-item emp-offer-letter" href="#" data-id="<?= $row2['sn']; ?>">Offer Letter</a></li>
                <li><a class="dropdown-item emp-joining-letter" href="#" data-id="<?= $row2['sn']; ?>"
                       onclick="return confirm('Are you sure?')">Joining Letter</a></li>
                <li><a class="dropdown-item candidate-letter" href="#" data-id="<?= $row2['sn']; ?>">Candidate Letter</a></li>
                <li><a class="dropdown-item candidate-bio-data" href="#" data-id="<?= $row2['sn']; ?>"
                       onclick="return confirm('Are you sure?')">BIO Data</a></li>
                <li><a class="dropdown-item emp-termination-letter" href="#" data-id="<?= $row2['sn']; ?>"
                       onclick="return confirm('Are you sure?')">Termination Letter</a></li>
            </ul>
        </div>
    </td>

    <td><?= htmlspecialchars($row2['e_doj']); ?></td>
    <td><?= htmlspecialchars($row2['salary']); ?></td>
    <td><?= htmlspecialchars($row2['uan_no']); ?></td>
    <td><?= htmlspecialchars($row2['bank_ac_no']); ?></td>
    <td><?= htmlspecialchars($row2['esic_no']); ?></td>

    <td>
        <div class="invoice-action">
            <a href="employee-details.php?id=<?= $row2['sn']; ?>" class="invoice-action-view mr-4">
                <i class="lni lni-eye"></i>
            </a>
            <a href="edit-employee.php?id=<?= $row2['e_id']; ?>" class="invoice-action-edit">
                <i class="bi bi-pencil-square"></i>
            </a>
            <a href="left-employee.php?branch=<?= $row2['branch']; ?>&e-id=<?= $row2['e_id']; ?>&doj=<?= $row2['e_doj']; ?>"
               onclick="return confirm('Are you want to delete this record ?')"
               class="invoice-action-view mr-4">
                <i class="lni lni-trash"></i>
            </a>
        </div>
    </td>
</tr>
<?php } ?>
</tbody>

                                <tfoot>
                                    <tr>
                                        <th>SR No</th>
                                        <th>Id No</th>
                                        <th>Branch</th>
                                        <th>Employee Name</th>
                                        <th>Father Name</th>
                                        <th>Designation</th>
                                        <th>Mobile Number</th>
                                        <th>OT</th>
                                        <th>PF</th>
                                        <th>ESIC</th>
                                        <th>Dob</th>
                                        <th>Doj</th>
                                        <th>Salary</th>
                                        <th>UAN Number</th>
                                        <th>Bank Account Number</th>
                                        <th>ESIC Number</th>
                                        <th>Action</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <!-- end page content-->
        </div>
        <div class="modal fade" id="candidateModal" tabindex="-1" role="dialog" aria-labelledby="candidateModalLabel"
            aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="candidateModalLabel">Candidate Letter</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <form id="candidateForm">
                            <input type="hidden" id="candidateId" name="id">
                            <table class="table">
                                <tr>
                                    <td>Date of Interview</td>
                                    <td><input type="date" class="form-control" id="interviewDate" name="interview_date" required></td>
                                </tr>
                                <tr>
                                    <td>Date of Joining</td>
                                    <td><input type="date" class="form-control" id="joiningDate" name="joining_date" required></td>
                                </tr>
                                <tr>
                                    <td>Salary (Gross Pay)</td>
                                    <td><input type="text" class="form-control" id="salary" name="salary" required></td>
                                </tr>
                                <tr>
                                    <td>Duty Hours</td>
                                    <td><input type="text" class="form-control" id="dutyHours" name="duty_hours" required></td>
                                </tr>
                            </table>
                            <button type="submit" class="btn btn-primary">Generate PDF</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="joiningModal" tabindex="-1" role="dialog" aria-labelledby="joiningModalLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="joiningModalLabel">Employee Offer Letter</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <form id="joiningForm">
                            <input type="hidden" id="joiningId" name="joiningId">
                            <table class="table">
                                <tr>
                                    <td>Probation Period(months)</td>
                                    <td><input type="number" class="form-control" id="period" name="period" required></td>
                                </tr>
                            </table>
                            <button type="submit" class="btn btn-primary">Generate PDF</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <?php include 'system/footer.php'?>

        <script src="assets/js/html2pdf.bundle.min.js"></script>
        <script>
        // $(document).ready(function() {

        //     $('#candidate-letter').click(function() {

        //         var candidateId = $(this).data('id'); // Get the ID from the data attribute



        //         $.ajax({

        //             url: 'emp-offer-letter.php',

        //             type: 'POST',

        //             data: {

        //                 id: candidateId

        //             }, // Send the ID in the request

        //             success: function(response) {

        //                 var fileName = 'candidate-letter-' + candidateId + '-' +

        //                     currentDate + '.pdf';

        //                 html2pdf().from(response).save(fileName);

        //             },

        //             error: function(xhr, status, error) {

        //                 console.error('Error fetching offer letter:', error);

        //             }

        //         });

        //     });

        // });





        $(document).ready(function () {

    // Handle click event on "Candidate Letter" button

    $('.candidate-letter').click(function (event) {

        event.preventDefault(); // Prevent default link behavior



        var confirmation = confirm("Are you sure you want to perform this task?");

        if (!confirmation) return; // If user cancels, do nothing



        var candidateId = $(this).data('id');

        var currentDate = new Date().toISOString().slice(0, 10); // YYYY-MM-DD format



        $.ajax({

            url: 'candidate-letter.php',

            type: 'POST',

            data: {

                id: candidateId

            },

            success: function (response) {

                var fileName = 'candidate-letter-' + candidateId + '-' + currentDate + '.pdf';

                html2pdf().from(response).save(fileName);

            },

            error: function (xhr, status, error) {

                console.error('Error generating offer letter:', error);

            }

        });

    });

});



        </script>



        <script>

//            $(document).ready(function () {

//     // Handle click event on "Candidate Letter" button

//     $('#candidate-bio-data').click(function (event) {

//         event.preventDefault(); // Prevent default link behavior



//         var confirmation = confirm("Are you sure you want to perform this task?");

//         if (!confirmation) return;



//         var candidateId = $(this).data('id');

//         $('#candidateId').val(candidateId);

//     });



//     // Submit form to generate offer letter

//     $('#candidateForm').submit(function (event) {

//         event.preventDefault(); // Prevent page reload



//         var formData = $(this).serialize(); // Serialize form data

//         var candidateId = $('#candidateId').val();

//         var currentDate = new Date().toISOString().split('T')[0];



//         $.ajax({

//             url: 'emp-offer-letter.php',

//             type: 'POST',

//             data: formData,

//             success: function (response) {

//                 var fileName = 'candidate-letter-' + candidateId + '-' + currentDate + '.pdf';

//                 html2pdf().from(response).save(fileName);

//                 $('#candidateModal').modal('hide'); // Close modal after success

//             },

//             error: function (xhr, status, error) {

//                 console.error('Error generating offer letter:', error);

//             }

//         });

//     });

// });





//         $(document).ready(function() {

//             $('#candidate-bio-data').click(function() {

//                 var candidateId = $(this).data('id');

//                 $.ajax({

//                     url: 'emp-bio-data.php',

//                     type: 'POST',

//                     data: {

//                         id: candidateId

//                     }, // Send the ID in the request

//                     success: function(response) {

//     var tempDiv = $('<div>').html(response).appendTo('body'); // Append to body

//     var fileName = 'candidate-bio-data-' + candidateId + '-' + new Date().toISOString().split('T')[0] + '.pdf';



//     html2pdf().from(tempDiv[0]).save(fileName);



//     tempDiv.remove(); // Remove the temporary div after PDF generation

// },

//                     error: function(xhr, status, error) {

//                         console.error('Error fetching offer letter:', error);

//                     }

//                 });

//             });

//         });

$(document).ready(function() {

    $('.candidate-bio-data').click(function() {

        var candidateId = $(this).data('id');



        $.ajax({

            url: 'emp-bio-data.php',

            type: 'POST',

            data: { id: candidateId }, // Send the candidate ID in the request

            success: function(response) {

                var tempDiv = $('<div>').html(response).css({

                    'max-width': '800px',

                    'font-size': '12px',

                    'line-height': '1.2',

                    'padding': '10px',

                    'margin': 'auto'

                }).appendTo('body'); // Append to body temporarily

                

                var fileName = 'candidate-bio-data-' + candidateId + '-' + new Date().toISOString().split('T')[0] + '.pdf';



                html2pdf(tempDiv[0], {

                    margin: 5,  // Reduce margins for single-page output

                    filename: fileName,

                    pagebreak: { mode: ['avoid-all', 'css', 'legacy'] }, // Prevent unnecessary page breaks

                    image: { type: 'jpeg', quality: 0.98 },

                    html2canvas: { scale: 2, useCORS: true },

                    jsPDF: { unit: 'mm', format: 'a4', orientation: 'portrait' }

                }).then(() => tempDiv.remove()); // Remove the temp div after PDF generation

            },

            error: function(xhr, status, error) {

                console.error('Error fetching candidate bio-data:', error);

            }

        });

    });

});



        </script>



        <script>

          $(document).ready(function() {

    $('.emp-termination-letter').click(function() {

        var candidateId = $(this).data('id');



        $.ajax({

            url: 'emp-termination-letter.php',

            type: 'POST',

            data: { id: candidateId }, // Send the candidate ID in the request

            success: function(response) {

                var tempDiv = $('<div>').html(response).css({

                    'max-width': '800px',

                    'font-size': '12px',

                    'line-height': '1.2',

                    'padding': '10px',

                    'margin': 'auto'

                }).appendTo('body');

                

                var fileName = 'EMP-Termination-Letter-' + candidateId + '-' + new Date().toISOString().split('T')[0] + '.pdf';



                html2pdf(tempDiv[0], {

                    margin: 5,  // Reduce margins for single-page output

                    filename: fileName,

                    pagebreak: { mode: ['avoid-all', 'css', 'legacy'] }, // Prevent unnecessary page breaks

                    image: { type: 'jpeg', quality: 0.98 },

                    html2canvas: { scale: 2, useCORS: true },

                    jsPDF: { unit: 'mm', format: 'a4', orientation: 'portrait' }

                }).then(() => tempDiv.remove()); // Remove the temp div after PDF generation

            },

            error: function(xhr, status, error) {

                console.error('Error fetching candidate bio-data:', error);

            }

        });

    });

});

          

        </script>





<script>



$(document).ready(function () {

    // Handle click event on "Candidate Letter" button

    $('.emp-offer-letter').click(function (event) {

        event.preventDefault(); // Prevent default link behavior



        var confirmation = confirm("Are you sure you want to perform this task?");

        if (!confirmation) return; // If user cancels, do nothing



        var joiningId = $(this).data('id');



        $.ajax({

            url: 'emp-offer-letter.php',

            type: 'POST',

            data: {

                id: joiningId

            },

            success: function (response) {

              var tempDiv = $('<div>').html(response).css({

                    'max-width': '800px',

                    'font-size': '12px',

                    'line-height': '1.2',

                    'padding': '10px',

                    'margin': 'auto'

                }).appendTo('body');

                

                var fileName = 'EMP-Offer-Letter-' + joiningId + '-' + new Date().toISOString().split('T')[0] + '.pdf';



                html2pdf(tempDiv[0], {

                    margin: 5,  // Reduce margins for single-page output

                    filename: fileName,

                    pagebreak: { mode: ['avoid-all', 'css', 'legacy'] }, // Prevent unnecessary page breaks

                    image: { type: 'jpeg', quality: 0.98 },

                    html2canvas: { scale: 2, useCORS: true },

                    jsPDF: { unit: 'mm', format: 'a4', orientation: 'portrait' }

                }).then(() => tempDiv.remove()); // Remove the temp div after PDF generation

            },

            error: function (xhr, status, error) {

                console.error('Error generating offer letter:', error);

            }

        });

    });

});







          $(document).ready(function() {

    $('.emp-joining-letter').click(function() {

        var joiningId = $(this).data('id');



        $.ajax({

            url: 'emp-joining-letter.php',

            type: 'POST',

            data: { id: joiningId }, // Send the candidate ID in the request

            success: function(response) {

                var tempDiv = $('<div>').html(response).css({

                    'max-width': '800px',

                    'font-size': '12px',

                    'line-height': '1.2',

                    'padding': '10px',

                    'margin': 'auto'

                }).appendTo('body');

                

                var fileName = 'EMP-Joining-Letter-' + candidateId + '-' + new Date().toISOString().split('T')[0] + '.pdf';



                html2pdf(tempDiv[0], {

                    margin: 5,  // Reduce margins for single-page output

                    filename: fileName,

                    pagebreak: { mode: ['avoid-all', 'css', 'legacy'] }, // Prevent unnecessary page breaks

                    image: { type: 'jpeg', quality: 0.98 },

                    html2canvas: { scale: 2, useCORS: true },

                    jsPDF: { unit: 'mm', format: 'a4', orientation: 'portrait' }

                }).then(() => tempDiv.remove()); // Remove the temp div after PDF generation

            },

            error: function(xhr, status, error) {

                console.error('Error fetching candidate bio-data:', error);

            }

        });

    });

});

          

        </script>
