<?php  

session_start();
if(!$_SESSION['id']){
    header('location:index.php');
}

  require_once '../system/conn.php';

$stmt = $conn->prepare("SELECT * FROM `emp_details` WHERE `sn` = ?");
$stmt->execute([$_POST['id']]);
$emp = $stmt->fetch(PDO::FETCH_ASSOC);

// Fetch candidate details (if needed)
$candidate_stmt = $conn->prepare("SELECT * FROM `candidate_details` LIMIT 1");
$candidate_stmt->execute();
$candidate = $candidate_stmt->fetch(PDO::FETCH_ASSOC);

// Determine image (Employee's image takes priority)
$image = !empty($emp['image']) ? $emp['image'] : (!empty($candidate['photo']) ? $candidate['photo'] : 'default-image.jpg'); // Provide a default image if none exists

?>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">

<style>

.letter-container {
    width: 98%; /* Reduced width */
    margin: 10px auto;
    padding: 15px;
    border: 1px solid #000;
    font-family: 'Arial', sans-serif;
    font-size: 11px; /* Reduced font size */
}

.header img {
    width: 60px; /* Reduced logo size */
}

.details-table td {
    padding: 4px; /* Reduced padding */
    font-size: 10px;
}

.header {
    display:flex;
    flex-direction:column;
    justify-content:center;
    margin-bottom: 20px;
}


.header h1 {
    font-size: 22px;
    text-transform: uppercase;
    margin: 0;
    font-weight: bold;
}

.sub-header {
    text-align: center;
    font-size: 16px;
    font-weight: 600;
    margin-bottom: 20px;
}

.details-table {
    width: 100%;
    border-collapse: collapse;
    margin-bottom: 20px;
}



.details-table td:first-child {
    font-weight: bold;
    width: 30%;
}

.signature-section {
    margin-top: 40px;
    display: flex;
    justify-content: space-between;
}

.signature-block {
    text-align: center;
}
</style>
<style>
.application-form {
    width: 95%;
    margin: 20px auto;
    padding: 20px;
    border: 2px solid #000;
    border-radius: 10px;
    font-family: Arial, sans-serif;
    background: #fff;
}

.application-form h2 {
    text-align: center;
    margin-bottom: 20px;
}

.form-container {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
}

.form-table {
    width: 100%;
    border-collapse: collapse;
}

.form-table td {
    padding: 10px;
}

.form-table td:first-child {
    font-weight: bold;
    width: 25%;
    background: #f1f1f1;
}

.photo-container {
    width: 30%;
    text-align: center;
}

.photo-container img {
    width: 150px;
    height: 150px;
    border-radius: 10px;
    border: 2px solid #000;
}

.section-divider {
    margin-top: 20px;
    border-top: 2px solid black;
    padding-top: 20px;
}

.dual-row td {
    width: 50%;
    white-space: nowrap; /* Prevents text from breaking */
    text-align: left;
}
.tri-row td {
    width: 16.66%!important; /* Each column takes exactly 16.66% */
    white-space: nowrap; /* Prevents text from breaking */
    text-align: left; /* Ensures proper alignment */
}

</style>
<?php
$biodata = '<div class="letter-container">
    <div class="header">

        <h1 style="text-align:center">UTKAL TEAM CARE PVT LTD</h1>
        <p class="sub-header">Candidate BIO Data</p>

        
    </div>
    <div class="application-form">
        <div class="form-container">
            <!-- Left side: Data -->
            <table class="form-table">
                <tr>
                    <td>Post Applied for</td>
                    <td>: ' . htmlspecialchars($candidate['desired_position'] ?? '') . '</td>
                </tr>
                <tr>
                    <td>Full Name</td>
                    <td>: ' . htmlspecialchars($emp['e_name'] ?? $emp['e_name'] ?? '') . '</td>
                </tr>
                <tr>
                    <td>Father\'s Name</td>
                    <td>: ' . htmlspecialchars($emp['fname'] ?? $emp['fname'] ?? '') . '</td>
                </tr>
                <tr>
                    <td>Mother\'s Name</td>
                    <td>: ' . htmlspecialchars($emp['mname'] ?? $emp['mname'] ?? '') . '</td>
                </tr>
                <tr class="dual-row">
                    <td>Spouse\'s Name</td>
                    <td>: ' . htmlspecialchars($emp['husband_wife'] ?? $emp['husband_wife'] ?? '') . '</td>
                    <td width="25%">Date of Birth</td>
                    <td width="25%">: ' . htmlspecialchars($emp['dob'] ?? $emp['dob'] ?? '') . '</td>
                </tr>
                <tr class="dual-row">
                    <td>Contact Number</td>
                    <td>: ' . htmlspecialchars($emp['mobile_num'] ?? $emp['mobile_num'] ?? '') . '</td>
                    <td width="25%">Alternate Contact</td>
                    <td width="25%">: ' . htmlspecialchars($emp['alt_mob_no'] ?? $emp['alt_mob_no'] ?? '') . '</td>
                </tr>
            </table>

            <!-- Right side: Candidate Photo -->
            <div class="photo-container">
                <img src="http://hr.utcpl.co.in/hrm/assets/images/employee/' . htmlspecialchars($image) . '" alt="Candidate Photo">
            </div>
        </div>

        <div class="section-divider"></div>

        <table class="form-table">
            <tr class="dual-row">
    <td width="25%">Marital Status</td>
    <td width="25%">: '. htmlspecialchars($candidate['maritial-status'] ?? '') .'</td>
    <td width="25%">Education</td>
    <td width="25%">: '. htmlspecialchars($candidate['education'] ?? '') .'</td>
</tr>
<tr class="dual-row">
    <td width="25%">Languages Known</td>
    <td width="25%">: '. htmlspecialchars($candidate['language'] ?? '') .'</td>
    <td width="25%">Experience</td>
    <td width="25%">: '. htmlspecialchars($candidate['experience'] ?? '') .'</td>
</tr>
<tr class="dual-row">
    <td width="25%">Nationality</td>
    <td width="25%">: '. htmlspecialchars($candidate['nationality'] ?? '') .'</td>
    <td width="25%">Religion</td>
    <td width="25%">: '. htmlspecialchars($candidate['religion'] ?? '') .'</td>
</tr>

            <tr class="tri-row">
                <td width="16.66%">Gender</td>
                <td width="16.66%">: '. htmlspecialchars($candidate['gender'] ?? ''). '</td>
                <td width="16.66%">Height</td>
                <td width="16.66%">: '. htmlspecialchars($candidate['height'] ?? ''). ' cm</td>
                <td width="16.66%">Weight</td>
                <td width="16.66%">: '. htmlspecialchars($candidate['weight'] ?? ''). ' kg</td>
            </tr>

            <tr class="dual-row">
                
                <td>Aadhar Number</td>
                <td>: ' . htmlspecialchars($emp['aadhar_num'] ?? $emp['aadhar_num'] ?? '') . '</td>
            </tr>
            <tr class="dual-row">
                <td>Permanent Address</td>
                <td colspan="3">: ' . htmlspecialchars($emp['addr'] ?? $emp['addr'] ?? '') . '</td>
            </tr>
        </table>
    </div>
    <h4 style="text-align:center">DECLARATION OF THE CANDIDATES</h4>
    <ul>
        <li>1. I do hereby declare that the above statement is true to the best of my knowledge and belief.</li>
        <li>2. I will render my service to the best of my ability and agree to rules and regulations of the service provider.</li>
        <li>3. I do hereby declare that I will survive the 30 Day\'s (Technical, Sup, Executive & Manager) 15 Days\' (S Guard, Gardener, Peon & HK staff) Notice Period before quitting the job and If I quit the job without completing the Notice Period then the salary will be held by the Company.</li>
        <li>4. I do hereby declare that I am agreeing with the amount Rs.2500/- uniform money will be deducted from my salary which shall be non-returnable.</li>
        <li>5. I do hereby declare that a Police verification acknowledgment slip must be deposited within 15 days & certificate within 1 month from the date of joining.</li>
    </ul>
    <div class="signature-section">
        <div class="signature-block">
            <p>Candidate\'s Signature</p>
        </div>
        <div class="signature-block">
            <p style="text-align: right; border: 0!important; margin-top: 20px;">
                <strong>Date:</strong> ' . date("d-m-Y") . '<br>
                <strong>Time:</strong> ' . date("h:i A") . '
            </p>
        </div>
    </div>
    <hr>
    <footer>
        <p style="text-align:center"><strong><big>UTKAL Team Care (P) Ltd.</big></strong></p>
    </footer>
</div>';

echo $biodata;
?>
