<?php
session_start();
$date=explode('-',date("Y-m-d", strtotime("last day of previous month")));
$month=$date[1];
$year=$date[0];


$monthNum  =$month;
$dateObj   = DateTime::createFromFormat('!m', $monthNum);
$monthName = strtoupper($dateObj->format('F'));

// CONNECT TO DATABASE
// ! CHANGE THESE SETTINGS TO YOUR OWN !
      require_once '../system/conn.php';

// CREATE PHPSPREADSHEET OBJECT
require "excel_test/vendor/autoload.php";
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// CREATE A NEW SPREADSHEET + POPULATE DATA
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();
$spreadsheet->getActiveSheet()->mergeCells('A1:G1');
$spreadsheet->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);




$styleArray = [
    'font' => [
        'bold' => true,
    ],
    'alignment' => [
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
    ],
    'fill' => [
        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_GRADIENT_LINEAR,
        'rotation' => 90,
        'startColor' => [
            'argb' => 'FFA0A0A0',
        ],
        'endColor' => [
            'argb' => 'FFFFFFFF',
        ],
    ],
];
$styleArray1 = [
    'font' => [
        'bold' => true,
    ],
    'alignment' => [
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
    ],
];

$spreadsheet->getActiveSheet()->getStyle('A3:G3')->applyFromArray($styleArray1);
$spreadsheet->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);



$sheet->setTitle('OT Cheque sheet');
$stmt = $conn->prepare("SELECT `emp_name`,`emp_id`,`branch`,`Designation`,`ac_no`,`amount` FROM `ot_details` WHERE `month`='$month' AND `year`='$year' AND (`cheque`='yes' OR `ac_no`='')  UNION SELECT 'z', '','','','TOTAL', SUM(`amount`) from `ot_details` WHERE  `month`='$month' AND `year`='$year' AND (`cheque`='yes' OR `ac_no`='')");
    
$stmt->execute();
$a = 1;
$i = 4;
  $sheet->setCellValue('A1', ' OT CHEQUE SHEET FOR THE '.$monthName.' '. $year);
  $sheet->setCellValue('A3', 'SR NO');
  $sheet->setCellValue('B3', 'NAME');
  $sheet->setCellValue('C3', 'EMP ID');
  $sheet->setCellValue('D3', 'BRANCH');
  $sheet->setCellValue('E3', 'DESIGNATION');
  $sheet->setCellValue('F3', 'ACCOUNT');
  $sheet->setCellValue('G3', 'NET');
   
   
while ($row = $stmt->fetch(PDO::FETCH_NAMED)) {
  $sheet->setCellValue('A'.$i, $a);
  $sheet->setCellValue('B'.$i, $row['emp_name']);
  $sheet->setCellValue('C'.$i, $row['emp_id']);
   
   $stmt1 = $conn->prepare("SELECT `name`  from branch WHERE `id`='".$row['branch']."' ");
    $stmt1->execute();
    while ($row1 = $stmt1->fetch(PDO::FETCH_NAMED)) {
      $sheet->setCellValue('D'.$i, $row1['name']);
    }
   
  $sheet->setCellValue('E'.$i, $row['Designation']);
  $sheet->setCellValue('F'.$i, $row['ac_no']);
  $sheet->setCellValue('G'.$i, $row['amount']);
  
  
 
  $i++;
  $a++;
}

$spreadsheet->getActiveSheet()->getStyle('A'.$i.':G'.$i)->applyFromArray($styleArray1);


// OUTPUT
$writer = new Xlsx($spreadsheet);
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="OT-Cheque(Admin).xlsx"');
header('Cache-Control: max-age=0');
header('Expires: Fri, 11 Nov 2011 11:11:11 GMT');
header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
header('Cache-Control: cache, must-revalidate');
header('Pragma: public');
$writer->save('php://output');
?>