<?php 
    session_start();
    if(!$_SESSION['id']){
        header('location:index.php');
    }
    require_once '../system/conn.php';
?>
<!doctype html>
<html lang="en" class="semi-dark">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
	<link href="assets/css/pace.min.css" rel="stylesheet" />
	<script src="assets/js/pace.min.js"></script>
    <link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
    <link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
    <link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
    <link href="assets/plugins/datatable/css/dataTables.bootstrap5.min.css" rel="stylesheet" />
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/bootstrap-extended.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
    <link href="assets/css/icons.css" rel="stylesheet">
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    <link href="assets/css/dark-theme.css" rel="stylesheet" />
    <link href="assets/css/semi-dark.css" rel="stylesheet" />
    <link href="assets/css/header-colors.css" rel="stylesheet" />
    <title><?php echo $_POST['ex']; ?> Year Of Employee Experience</title>
  </head>
  <body>
    <div class="wrapper">
    <?php include'system/header.php'?>
	    <div class="page-content-wrapper">
         <div class="page-content">
          <!--start breadcrumb-->
          <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3"><?php echo $_POST['ex']; ?> Year Of Experience</div>
             <div class="ms-auto">
                <a href="excel-experience.php?ex=<?php echo $_POST['ex']; ?>"><button type="button" class="btn btn-primary px-5">Excel Download</button></a>
             </div>
          </div>
			<hr/>
            
            
                <div class="card">
					<div class="card-body">
						<div class="table-responsive">
							<table id="example2" class="table table-striped table-bordered">
								<thead>
									<tr>
										<th>SR No</th>
            							<th>Id No</th>
            							<th>Branch</th>
                                        <th>Employee Name</th>
                                        <th>Designation</th>
                                        <th>Mobile Number</th>
                                        <th>Adhara Number</th>
                                        <th>PAN Number</th>
                                        <th>Dob</th>
                                        <th>Doj</th>
                                        <th>Salary</th>
                                        <th>UAN Number</th>
                                        <th>Bank Account Number</th>
                                        <th>Address</th>
                                        <th>Action</th>
									</tr>
								</thead>
								<tbody>
<?php
$i = 1;
$ex = (int)($_POST['ex'] ?? 0);

$stmt = $conn->prepare("
    SELECT 
        e.*,
        b.name AS branch_name
    FROM emp_details e
    LEFT JOIN branch b ON b.id = e.branch
");

$stmt->execute();
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

foreach ($rows as $row) {

    // Parse e_doj in DD/MM/YYYY format
    $doj = DateTime::createFromFormat('d/m/Y', $row['e_doj']);
    if (!$doj) {
        // Skip if date is invalid
        continue;
    }

    $now = new DateTime();
    $experience = $now->diff($doj)->y;

    if ($experience !== $ex) {
        continue;
    }
?>
<tr>
    <td><?= $i++; ?></td>

    <td>
        <a href="view-details-all-emp.php?id=<?= $row['sn']; ?>">
            <?= htmlspecialchars($row['e_id']); ?>
        </a>
    </td>

    <td><?= htmlspecialchars($row['branch_name']); ?></td>
    <td><?= htmlspecialchars($row['e_name']); ?></td>
    <td><?= htmlspecialchars($row['designation']); ?></td>
    <td><?= htmlspecialchars($row['mobile_num']); ?></td>
    <td><?= htmlspecialchars($row['aadhar_num']); ?></td>
    <td><?= htmlspecialchars($row['pan_card']); ?></td>
    <td><?= htmlspecialchars($row['dob']); ?></td>
    <td><?= htmlspecialchars($row['e_doj']); ?></td>
    <td><?= htmlspecialchars($row['salary']); ?></td>
    <td><?= htmlspecialchars($row['uan_no']); ?></td>
    <td><?= htmlspecialchars($row['bank_ac_no']); ?></td>
    <td><?= htmlspecialchars($row['addr']); ?></td>

    <td>
        <div class="invoice-action">
            <a href="employee-details.php?id=<?= $row['sn']; ?>" class="invoice-action-view mr-4">
                <i class="lni lni-eye"></i>
            </a>

            <a href="edit-employee.php?id=<?= $row['sn']; ?>" class="invoice-action-edit">
                <i class="bi bi-pencil-square"></i>
            </a>

            <a href="left-employee.php?branch=<?= $row['branch']; ?>&e-id=<?= $row['e_id']; ?>"
               onclick="return confirm('Are you sure you want to delete this record?')"
               class="invoice-action-view mr-4">
                <i class="lni lni-trash"></i>
            </a>
        </div>
    </td>
</tr>
<?php } ?>
</tbody>



								<tfoot>
									<tr>
										<th>SR No</th>
            							<th>Id No</th>
            							<th>Branch</th>
                                        <th>Employee Name</th>
                                        <th>Designation</th>
                                        <th>Mobile Number</th>
                                        <th>Adhara Number</th>
                                        <th>PAN Number</th>
                                        <th>Dob</th>
                                        <th>Doj</th>
                                        <th>Salary</th>
                                        <th>UAN Number</th>
                                        <th>Bank Account Number</th>
                                        <th>Address</th>
                                        <th>Action</th>
									</tr>
								</tfoot>
							</table>
						</div>
					</div>
			    </div>

          </div>
          <!-- end page content-->
         </div>

<?php include'system/footer.php'?>