<?php
session_start();
require_once('../system/conn.php');
if(isset($_POST['submit']))
{
	if(isset($_POST['username'],$_POST['password']) && !empty($_POST['username']) && !empty($_POST['password']))
	{
		$username = trim($_POST['username']);
		$password = trim($_POST['password']);
		
			$handle =  $conn->prepare("SELECT * FROM `admin_login` WHERE `username` = ?");
			$handle->execute([$username]);
			if($handle->rowCount() > 0)
			{
				$getRow = $handle->fetch(PDO::FETCH_ASSOC);
				if(password_verify($password, $getRow['password']))
				{
					unset($getRow['password']);
					$_SESSION = $getRow;
					header('location:home.php');
					exit();
				}
				else
				{
					$errors[] = "Wrong Username or Password";
				}
			}
			else
			{
				$errors[] = "Wrong Username or Password";
			}
		
	}
	else
	{
		$errors[] = "Username and Password are required";	
	}
}
?>
<!doctype html>
<html lang="en" class="light-theme">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- loader-->
  <link href="assets/css/pace.min.css" rel="stylesheet" />
  <script src="assets/js/pace.min.js"></script>
  <!--plugins-->
  <link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
  <!-- CSS Files -->
  <link href="assets/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/css/bootstrap-extended.css" rel="stylesheet">
  <link href="assets/css/style.css" rel="stylesheet">
  <link href="assets/css/icons.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css">
  <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">

  <title>UTCPL Admin Panel</title>
</head>

<body class="bg-white">
    
  <!--start wrapper-->
  <div class="wrapper">
    <div class="">
      <div class="row g-0 m-0">
          <div class="col-xl-6 col-lg-12">
            <div class="login-cover-wrapper">
                <div class="card shadow-none">
                  <div class="card-body">
                    <div class="text-center">
                      <h4>Sign In</h4>
                      <p>Sign In to your account</p>
                    </div>
                    <?php 
                	  if(isset($errors) && count($errors) > 0)
                	   {
                		  foreach($errors as $error_msg)
                		  {
                			echo '<div class="alert alert-danger">'.$error_msg.'</div>';
                		  }
                	   }
                	?>
			    <form class="form-body row g-3" method="POST" >
                  <div class="col-12">
                    <label for="inputName" class="form-label">User Name</label>
                    <input type="text" name="username" class="form-control" id="inputName">
                  </div>
                  <div class="col-12">
                    <label for="inputPassword" class="form-label">Password</label>
                    <input type="password" name="password" class="form-control" id="inputPassword">
                  </div>
                  <div class="col-12 col-lg-6">
                    <div class="form-check form-switch">
                      <input class="form-check-input" type="checkbox" role="switch" id="flexSwitchCheckRemember">
                      <label class="form-check-label" for="flexSwitchCheckRemember">Remember Me</label>
                    </div>
                  </div>
                  <div class="col-12 col-lg-6 text-end">
                  </div>
                  <div class="col-12 col-lg-12">
                    <div class="d-grid">
                      <button class="btn btn-dark" type="submit" name="submit">Login</button>
                    </div>
                  </div>
			    </form>
              </div>
            </div>
          </div>
        </div>
        <div class="col-xl-6 col-lg-12">
          <div class="position-fixed top-0 h-100 d-xl-block d-none login-cover-img">
          </div>
        </div>
      </div>
    </div>
  </div>
		
  </body>
</html>