<?php 
    session_start();
    if(!$_SESSION['id']){
        header('location:index.php');
    }
    require_once '../system/conn.php';
?>
<!doctype html>
<html lang="en" class="semi-dark">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
	<link href="assets/css/pace.min.css" rel="stylesheet" />
	<script src="assets/js/pace.min.js"></script>
    <link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
    <link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
    <link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
    <link href="assets/plugins/datatable/css/dataTables.bootstrap5.min.css" rel="stylesheet" />
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/bootstrap-extended.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
    <link href="assets/css/icons.css" rel="stylesheet">
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    <link href="assets/css/dark-theme.css" rel="stylesheet" />
    <link href="assets/css/semi-dark.css" rel="stylesheet" />
    <link href="assets/css/header-colors.css" rel="stylesheet" />
    <title>New Employees List</title>
  </head>
  <body>
    <div class="wrapper">
    <?php include'system/header.php'?>
	  <div class="page-content-wrapper">
        <div class="page-content">
          <!--start breadcrumb-->
          <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">New Employees List</div>
            <div class="ms-auto">
                <a href="excel-new-employees.php"><button type="button" class="btn btn-primary px-5">Excel Download</button></a>
            </div>
          </div>
		  <hr/>
		  <div class="card">
			<div class="card-body">
			  <div class="table-responsive">
				<table id="example2" class="table table-striped table-bordered">
				  <thead>
					<tr>
						<th>SR No</th>
            			<th>Id No</th>
                        <th>Doj</th>
                        <th>Branch</th>
                        <th>Employee Name</th>
                        <th>Designation</th>
                        <th>Mobile Number</th>
                        <th>Alternate Mobile Number</th>
                        <th>Adhara Number</th>
                        <th>PAN Number</th>
                        <th>Dob</th>
                        <th>Salary</th>
                        <th>UAN Number</th>
                        <th>Bank Account Number</th>
                        <th>Address</th>
                        <th>Action</th>
					</tr>
				  </thead>
				  <tbody>
					<?php
                      $date1=date('Y-m-d');
                      $date=date('Y-m', strtotime(date('Y-m')." -1 month"));
                      $date=explode('-',$date);
                      $month=$date[1];
                      $dateObj   = DateTime::createFromFormat('!m', $month);
                      $monthName = $dateObj->format('F');
                      $year=$date[0];
                      $year1 = $year.'-'.$month.'-'.'01';
							    
                      $cnt = 1;
                      $stmt1 = $conn->prepare(" SELECT * FROM  emp_details WHERE e_doj BETWEEN '$year1' AND '$date1' AND status='1' order by `e_doj` desc ");
                      //print_r($stmt1);exit;
                      $stmt1->execute();
                      $sql = $stmt1->fetchAll(); 
                      foreach($sql as $row) 
                    { ?>
                    <tr>
                        <td><?php echo $cnt;?></td>
                        <td>
                            <a href="view-details-all-emp.php?id=<?php echo $row['sn'];?>"><?php echo $row['e_id'];?></a>
                        </td>
                        <td><?php echo $row['e_doj']; ?></td>
                        <td>
                            <?php
                                $sth1 = $conn->prepare("SELECT * FROM `branch` where id='".$row['branch']."' ");
                                $sth1->execute();
                                $row1 = $sth1->fetch(PDO::FETCH_ASSOC); 
                                echo $row1['name']; 
                            ?>
                        </td>
                        <td><?php echo $row['e_name'];?></td>
                        <td><?php echo $row['designation'];?></td>
                        <td><?php echo $row['mobile_num'];?></td>
                        <td><?php echo $row['alt_mob_no'];?></td>
                        <td><?php echo $row['aadhar_num'];?></td>
                        <td><?php echo $row['pan_card']; ?></td>
                        <td><?php echo $row['dob']; ?></td>
                        <td><?php echo $row['salary']; ?></td>
                        <td><?php echo $row['uan_no']; ?></td>
                        <td><?php echo $row['bank_ac_no']; ?></td>
                        <td><?php echo $row['addr']; ?></td>
                        <td>
                          <div class="invoice-action">
                            <a href="employee-details.php?id=<?php echo $row['sn'];?>" class="invoice-action-view mr-4"><i class="lni lni-eye"></i></a>
                            <a href="edit-employee.php?id=<?php echo $row['sn'];?>" class="invoice-action-edit"><i class="bi bi-pencil-square"></i></a>
                            <a href="left-employee.php?branch=<?php echo $row['branch'];?>&e-id=<?php echo $row['e_id'];?>" onclick="return confirm('Are you want to delete this record ?')" class="invoice-action-view mr-4" ><i class="lni lni-trash"></i></a>
                          </div>
                        </td>
                    </tr>
                    <?php  $cnt=$cnt+1; }?>
				  </tbody>
				  <tfoot>
					<tr>
						<th>SR No</th>
            			<th>Id No</th>
                        <th>Employee Name</th>
                        <th>Designation</th>
                        <th>Mobile Number</th>
                        <th>Adhara Number</th>
                        <th>PAN Number</th>
                        <th>Dob</th>
                        <th>Doj</th>
                        <th>Salary</th>
                        <th>UAN Number</th>
                        <th>Bank Account Number</th>
                        <th>Address</th>
                        <th>Action</th>
					</tr>
				  </tfoot>
				</table>
			  </div>
			</div>
		  </div>
             

        </div>
        <!-- end page content-->
      </div>
<?php include'system/footer.php'?>