<?php 
    session_start();
    if(!$_SESSION['id']){
        header('location:index.php');
    }
?>
<!doctype html>
<html lang="en" class="semi-dark">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
	<link href="assets/css/pace.min.css" rel="stylesheet" />
	<script src="assets/js/pace.min.js"></script>
    <link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
    <link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
    <link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
    <link href="assets/plugins/datatable/css/dataTables.bootstrap5.min.css" rel="stylesheet" />
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/bootstrap-extended.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
    <link href="assets/css/icons.css" rel="stylesheet">
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    <link href="assets/css/dark-theme.css" rel="stylesheet" />
    <link href="assets/css/semi-dark.css" rel="stylesheet" />
    <link href="assets/css/header-colors.css" rel="stylesheet" />
    <title>Current Gross Sheet</title>
  </head>
  <body>
    <div class="wrapper">
    <?php include'system/header.php'?>
	    <div class="page-content-wrapper">
         <div class="page-content">
          <!--start breadcrumb-->
          <?php
            $date=date('Y-m', strtotime(date('Y-m')." -1 month"));
            $date=explode('-',$date);
            $month=$date[1];
            $monthNum  = $month;
            $dateObj   = DateTime::createFromFormat('!m', $monthNum);
            $monthName = $dateObj->format('F');
            $year=$date[0];
          ?>
            <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
              <div class="breadcrumb-title pe-3">
                Current Gross Sheet (<?php echo $monthName;?>-<?php echo $year;?>)
              </div>
              <div class="ms-auto">
                <a href="delete-salary.php" class="btn btn-danger px-5" onclick="return confirm('Are you want to clear all employee salary table data of this month ?')">Delete Salary</a>
                <a href="attendace-processing.php" class="btn btn-success px-5"  onclick="return confirm('Are you want to clear all employee salary table data of this month ?')">Genarate Salary</a>
                <a href="excel-gross-sheet.php" class="btn btn-primary px-5" style="margin-top: 5px;">Excel download</a>
              </div>
            </div>
            <div class="col-sm-12">
              <?php if(isset($_SESSION['delete'])){?>
              <div class="alert alert-dismissible fade show py-2 bg-danger">
                <div class="d-flex align-items-center">
                  <div class="fs-3 text-white"><ion-icon name="close-circle-sharp" role="img" class="md hydrated" aria-label="close circle sharp"></ion-icon></div>
                  <div class="ms-3"><div class="text-white"><b><?php echo $_SESSION['delete'];?></b></div></div>
                </div>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
              </div>
              <?php }?>
              <?php if(isset($_SESSION['s_sa'])){?>
              <div class="alert alert-dismissible fade show py-2 bg-danger">
                <div class="d-flex align-items-center">
                  <div class="fs-3 text-white"><ion-icon name="close-circle-sharp" role="img" class="md hydrated" aria-label="close circle sharp"></ion-icon></div>
                  <div class="ms-3"><div class="text-white"><b><?php echo $_SESSION['s_sa'];?></b></div></div>
                </div>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
              </div>
              <?php }?>
            </div>
			<hr/>
			<div class="card">
			  <div class="card-body">
				<div class="table-responsive">
				  <table id="example2" class="table table-striped table-bordered">
					<thead>
					    <tr>
							<th>SR No</th>
                            <th>Employee Name</th>
                            <th>Designation</th>
                            <th>Employee Code</th>
                            <th>Paid Days</th>
                            <th>Branch</th>
                            <th>UAN Number</th>
                            <th>Basic Pay</th>
                            <th>HRA</th>
                            <th>Convyance</th>
                            <th>Medical</th>
                            <th>Gross Pay</th>
                            <th>PF</th>
                            <th>Esic</th>
                            <th>Staff Adv.</th>
                            <th>Professional Tax</th>
                            <th>Total Deduction</th>
                            <th>Net Pay</th>
						</tr>
					</thead>
					<tbody>
						<?php
							$date1=date('Y-m-d');
                            $date=date('Y-m', strtotime(date('Y-m')." -1 month"));
                            $date=explode('-',$date);
                            $month=$date[1];
                            $monthNum  = $month;
                            $dateObj   = DateTime::createFromFormat('!m', $monthNum);
                            $monthName = $dateObj->format('F');
                            $year=$date[0];
                            //$id=$_SESSION['branch'];
                            $cnt = 1;
                            $stmt1 = $conn->prepare("SELECT admin_emp_salary.emp_id, admin_emp_salary.name, admin_emp_salary.designation, admin_emp_salary.branch, admin_emp_salary.attendance, admin_emp_salary.basic_pay, admin_emp_salary.hra, admin_emp_salary.convyance, admin_emp_salary.medical, admin_emp_salary.gross_pay, admin_emp_salary.pf, admin_emp_salary.esic, admin_emp_salary.advance, admin_emp_salary.tax, admin_emp_salary.deduction, admin_emp_salary.net_pay, emp_details.uan_no  from admin_emp_salary  LEFT JOIN emp_details ON admin_emp_salary.emp_id=emp_details.e_id AND admin_emp_salary.branch=emp_details.branch WHERE admin_emp_salary.month='$month' AND admin_emp_salary.year='$year' UNION SELECT '', 'z', 'TOTAL', '', SUM(attendance), SUM(basic_pay), SUM(hra), SUM(convyance), SUM(medical), SUM(gross_pay), SUM(pf), SUM(esic), SUM(advance), SUM(tax), SUM(deduction), SUM(net_pay), '' from admin_emp_salary where `month`='$month' and `year`='$year' ORDER BY name ASC");
                            
                            //print_r($stmt1);exit;
                            $stmt1->execute();
                            $sql = $stmt1->fetchAll();
                            foreach($sql as $row) 
                        { ?>
                        <tr>
                            <td><?php echo $cnt;?></td>
                            <td><?php echo $row['name'];?></td>
                            <td><?php echo $row['designation']?></td>
                            <td><?php echo $row['emp_id']?></td>
                            <td><?php echo $row['attendance'];?></td>
                            <td>
                              <?php
                                $stmt = $conn->prepare(" SELECT name FROM `branch` where id='".$row['branch']."' ");
                                $stmt->execute();
                                $sql2 = $stmt->fetchAll(); 
                                foreach($sql2 as $row2) 
                                { 
                                    echo $row2['name']."<br>";  
                                }
                              ?>
                            </td>
                            <td><?php echo $row['uan_no']?></td>
                            <td><?php echo $row['basic_pay'];?></td>
                            <td><?php echo $row['hra'];?></td>
                            <td><?php echo $row['convyance'];?></td>
                            <td><?php echo $row['medical'];?></td>
                            <td><?php echo $row['gross_pay'];?></td>
                            <td><?php echo $row['pf'];?></td>
                            <td><?php echo $row['esic'];?></td>
                            <td><?php echo $row['advance'];?></td>
                            <td><?php echo $row['tax'];?></td>
                            <td><?php echo $row['deduction'];?></td>
                            <td><?php echo $row['net_pay'];?></td>    
                        </tr>
                        <?php  $cnt=$cnt+1; }?>
					</tbody>
					<tfoot>
						<tr>
							<th>SR No</th>
            				<th>Employee Name</th>
                            <th>Designation</th>
                            <th>Employee Code</th>
                            <th>UAN Number</th>
                            <th>Paid Days</th>
                            <th>Basic Pay</th>
                            <th>HRA</th>
                            <th>Convyance</th>
                            <th>Medical</th>
                            <th>Gross Pay</th>
                            <th>PF</th>
                            <th>Esic</th>
                            <th>Staff Adv.</th>
                            <th>Professional Tax</th>
                            <th>Total Deduction</th>
                            <th>Net Pay</th>
						</tr>
					</tfoot>
				  </table>
				</div>
			  </div>
			</div>
             
         </div>
         <!-- end page content-->
        </div>
         
    <?php
      if(isset($_SESSION['delete'])){
        unset($_SESSION['delete']);
      }
      if(isset($_SESSION['s_sa'])){
        unset($_SESSION['s_sa']);
      }
    ?>

<?php include'system/footer.php'?>