<?php 
    session_start();
    if(!$_SESSION['id']){
        header('location:index.php');
    }
?>
<!doctype html>
<html lang="en" class="semi-dark">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
	<link href="assets/css/pace.min.css" rel="stylesheet" />
	<script src="assets/js/pace.min.js"></script>
    <link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
    <link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
    <link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
    <link href="assets/plugins/datatable/css/dataTables.bootstrap5.min.css" rel="stylesheet" />
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/bootstrap-extended.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
    <link href="assets/css/icons.css" rel="stylesheet">
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    <link href="assets/css/dark-theme.css" rel="stylesheet" />
    <link href="assets/css/semi-dark.css" rel="stylesheet" />
    <link href="assets/css/header-colors.css" rel="stylesheet" />
    <title>OT Gross Sheet</title>
  </head>
  <body>
    <div class="wrapper">
    <?php include'system/header.php'?>
	    <div class="page-content-wrapper">
         <div class="page-content">
          <!--start breadcrumb-->
          <?php
            $date1=date('Y-m-d');
            $date=date('Y-m', strtotime(date('Y-m')." -1 month"));
            $date=explode('-',$date);
            $month=$date[1];
            $monthNum  = $month;
            $dateObj  = DateTime::createFromFormat('!m', $monthNum);
            $monthName = $dateObj->format('F');
            $year=$date[0];
          ?>
          <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">
                OT Gross Sheet (<?php echo $monthName;?>-<?php echo $year;?>)
            </div>
            <div class="ms-auto">
                <a href="excel-ot-gross-sheet.php" class="btn btn-primary px-5" style="margin-top: 5px;">Excel download</a>
            </div>
          </div>
			<hr/>
				<div class="card">
					<div class="card-body">
						<div class="table-responsive">
							<table id="example2" class="table table-striped table-bordered">
								<thead>
									<tr>
										<th>SR No</th>
            							<th>Employee Name</th>
            							<th>Branch</th>
                                        <th>Paid Days</th>
                                        <th>Per Day</th>
                                        <th>Net Pay</th>
									</tr>
								</thead>
								<tbody>
								    <?php
								    include('system/dbcon.php');
                                    $i=1;
                                    $select_inner=$con->query("SELECT * FROM `admin_salary_attendance` WHERE `month`='$month' AND `year`='$year' ");
                                    while($result=$select_inner->fetch_assoc())
                                     {
                                
                                     $s_s=$con->query("SELECT * FROM `emp_details` where `e_id`='".$result['emp_id']."' ");
                                     $r_r=$s_s->fetch_assoc();
                                     
                                     $g=(int)$r_r['salary'];//gross pay
                                     $day=$g/26;//perday
                                     $no_day=$result['o_a'];
                                     $g=$day*$result['o_a'];
                                     $g=round($g);
                                     $net_pay=$g;
                                     if($net_pay<0){
                                       $net_pay=0;
                                     }
                                     if($net_pay>0){
                                     ?>
                                    <tr>
                                      <td><?php echo $i; ?></td>
                                      <td><?php echo $r_r['e_name']; ?></td>
                                      <td>
                                        <?php
                                            $sth1 = $conn->prepare("SELECT * FROM `branch` where id='".$r_r['branch']."' ");
                                            $sth1->execute();
                                            $row1 = $sth1->fetch(PDO::FETCH_ASSOC);
                                            echo $row1['name']; ?>
                                      </td>
                                      <td><?php echo $no_day; ?></td>
                                      <td><?php echo round($day)?></td>
                                      <td><?php echo $net_pay; ?></td>
                                    </tr>
                                   <?php  
                                    $check=$con->query("SELECT * FROM `admin_ot_details` where `month`='$month' and `year`='$year' and  `emp_id`='".$result['emp_id']."'");
                                    $row_cnt = $check->num_rows;
                                    if($row_cnt == 0)
                                     {
                                       $sqlb = "INSERT INTO `admin_ot_details` (`emp_name`, `Designation`, `ac_no`, `emp_id`, `ot_days`, `amount`, `month`, `year`, `branch`, `Hold`, `cheque`) VALUES ('".$r_r['e_name']."', '".$r_r['designation']."', '".$r_r['bank_ac_no']."', '".$result['emp_id']."', '$no_day', '$net_pay', '$month', '$year', '".$result['branch']."', '".$result['block']."', '".$result['cheque']."')";
                                       $con->query($sqlb);
                                     }
                                   ?>    
                                   <?php $i++;}} ?> 
								</tbody>
								<tfoot>
									<tr>
										<th>SR No</th>
            							<th>Employee Name</th>
            							<th>Branch</th>
                                        <th>Paid Days</th>
                                        <th>Per Day</th>
                                        <th>Net Pay</th>
									</tr>
								</tfoot>
							</table>
						</div>
					</div>
				</div>
             

          </div>
          <!-- end page content-->
         </div>
<?php include'system/footer.php'?>