<?php 
    session_start();
    if(!$_SESSION['id']){
        header('location:index.php');
    }
    require_once '../system/conn.php';
?>
<!doctype html>
<html lang="en" class="semi-dark">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
	<link href="assets/css/pace.min.css" rel="stylesheet" />
	<script src="assets/js/pace.min.js"></script>
    <link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
    <link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
    <link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
    <link href="assets/plugins/datatable/css/dataTables.bootstrap5.min.css" rel="stylesheet" />
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/bootstrap-extended.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
    <link href="assets/css/icons.css" rel="stylesheet">
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    <link href="assets/css/dark-theme.css" rel="stylesheet" />
    <link href="assets/css/semi-dark.css" rel="stylesheet" />
    <link href="assets/css/header-colors.css" rel="stylesheet" />
    <title>UTCPL</title>
  </head>
  <body>
    <div class="wrapper">
    <?php include'system/header.php'?>
	    <div class="page-content-wrapper">
         <div class="page-content">
          <!--start breadcrumb-->
          <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">View Candidate Details</div>
          </div>
			<hr/>
				<div class="card">
					<div class="card-body">
						<div class="table-responsive">
                        <?php 


$stmt1 = $conn->prepare("SELECT * FROM `candidate_details` WHERE id=?");
$stmt1->execute([$_GET['id']]);
$row = $stmt1->fetch();

if (!$row) {
    echo "<p class='text-danger'>No candidate found.</p>";
    exit;
}
?>

    <style>
        .gov-form {
            border: 2px solid black;
            padding: 20px;
            font-family: 'Times New Roman', Times, serif;
            width: 90%;
            max-width: 700px;
            margin: 20px auto;
            background: #fff;
        }

        .gov-header {
            text-align: center;
            font-size: 18px;
            font-weight: bold;
            text-transform: uppercase;
            border-bottom: 2px solid black;
            padding-bottom: 5px;
        }

        .gov-sub-header {
            font-size: 12px;
            font-weight: bold;
            margin-top: 15px;
            background: #ddd;
            padding: 8px;
            border-left: 3px solid black;
        }

        .gov-photo {
            text-align: center;
            border: 1px solid black;
            width: 120px;
            height: 140px;
            line-height: 140px;
            margin: auto;
        }

        .gov-footer {
            text-align: center;
            margin-top: 20px;
            font-size: 14px;
        }

        /* Make photo responsive */
        .gov-photo img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
    </style>


<div class="gov-form">
    <div class="gov-header">UTCPL</div>
    <div class="header text-center"><h3>Candidate Details</h3></div>

    <div class="row text-center my-3">
        <div class="col-12">
            <div class="gov-photo">
                <?php if (!empty($row['photo'])): ?>
                    <img src="../assets/images/candidates/<?php echo $row['photo']; ?>" alt="Candidate Photo">
                <?php else: ?>
                    Photo
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="gov-sub-header">Personal Details</div>

    <div class="row">
        <div class="col-md-6"><strong>Full Name:</strong> <?php echo $row['full_name']; ?></div>
        <div class="col-md-6"><strong>Father's Name:</strong> <?php echo $row['father_name']; ?></div>
    </div>

    <div class="row">
        <div class="col-md-6"><strong>Date of Birth:</strong> <?php echo date("d M Y", strtotime($row['date_of_birth'])); ?></div>
        <div class="col-md-6"><strong>Gender:</strong> <?php echo ucfirst($row['gender']); ?></div>
    </div>

    <div class="row">
        <div class="col-md-6"><strong>Nationality:</strong> <?php echo $row['nationality']; ?></div>
        <div class="col-md-6"><strong>Marital Status:</strong> <?php echo ucfirst($row['maritial-status']); ?></div>
    </div>

    <div class="gov-sub-header">Additional Details</div>

    <div class="row">
        <div class="col-md-6"><strong>Blood Group:</strong> <?php echo $row['blood-group']; ?></div>
        <div class="col-md-6"><strong>Education:</strong> <?php echo $row['education']; ?></div>
    </div>

    <div class="row">
        <div class="col-md-6"><strong>Languages Known:</strong> <?php echo $row['language']; ?></div>
        <div class="col-md-6"><strong>Experience:</strong> <?php echo $row['experience']; ?> years</div>
    </div>

    <div class="row">
        <div class="col-md-6"><strong>Phone Number:</strong> <?php echo $row['phone_number']; ?></div>
        <div class="col-md-6"><strong>Alternate Phone:</strong> <?php echo $row['alternate_phone']; ?></div>
    </div>

    <div class="row">
        <div class="col-md-6"><strong>Aadhar Number:</strong> <?php echo $row['aadhar_number']; ?></div>
        <div class="col-md-6"><strong>Application Date:</strong> <?php echo date("d M Y", strtotime($row['date_of_application'])); ?></div>
    </div>

    <div class="gov-sub-header">Address Details</div>

    <div class="row">
        <div class="col-12"><strong>Address:</strong> <?php echo nl2br($row['address']); ?></div>
    </div>

</div>


						</div>
					</div>
				</div>
             

          </div>
          <!-- end page content-->
         </div>
<?php include 'system/footer.php'?>