<?php
    session_start();
    if(empty($_SESSION['branch']) || $_SESSION['branch'] == ''){
      header("Location: index.php");
      die();
    } 
    require_once 'system/conn.php';
?>
<!doctype html>
<html lang="en" class="semi-dark">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
	<link href="assets/css/pace.min.css" rel="stylesheet" />
	<script src="assets/js/pace.min.js"></script>
    <link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
    <link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
    <link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
    <link href="assets/plugins/datatable/css/dataTables.bootstrap5.min.css" rel="stylesheet" />
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/bootstrap-extended.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
    <link href="assets/css/icons.css" rel="stylesheet">
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    <link href="assets/css/dark-theme.css" rel="stylesheet" />
    <link href="assets/css/semi-dark.css" rel="stylesheet" />
    <link href="assets/css/header-colors.css" rel="stylesheet" />
    <title>All Employees</title>
  </head>
  <body>
  <div class="wrapper">
  <?php include'system/header.php'?>
	<div class="page-content-wrapper">
      <div class="page-content">
        <!--start breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
          <div class="breadcrumb-title pe-3">All Employees List</div>
          <div class="ms-auto">
            <a href="add-employee.php"><button type="button" class="btn btn-success px-5">Add New Employee</button></a>
            <a href="excel-employee.php"><button type="button" class="btn btn-primary px-5">Excel Download</button></a>
          </div>
        </div>
		<hr/>
		<div class="card">
		  <div class="card-body">
			<div class="table-responsive">
	    
			  <table id="example2" class="table table-striped table-bordered">
				<thead>
					<tr>
						<th>#</th>
						<th>Id No</th>
						<th>Other Branch</th>
                        <th>Employee Name</th>
                        <th>Father Name</th>
                        <th>Designation</th>
                        <th>Mobile Number</th>
                        <th>OT</th>
                        <th>PF</th>
                        <th>ESIC</th>
                        <th>Dob</th>
                        <th>Doj</th>
                        <th>Salary</th>
                        <th>UAN Number</th>
                        <th>Bank Account Number</th>
                        <th>ESIC Number</th>
                        <th>Action</th>
					</tr>
				</thead>
				<tbody>
					<?php 
                      $cnt = 1;
                      $stmt1 = $conn->prepare(" SELECT * FROM `emp_details` WHERE branch='".$_SESSION['branch']."' AND status= 1 ");
                      $stmt1->execute();
                      $sql = $stmt1->fetchAll();
                      //print_r($stmt1);exit;
                      foreach($sql as $row) 
                    { ?>
                    <tr>
                        <td><?php echo $cnt;?></td>
                        <td>
                            <a href="view-details-all-emp.php?id=<?php echo $row['sn'];?>"><?php echo $row['e_id'];?></a>
                        </td>
                        <td class="text-wrap" style="width: 15%;">
                        <?php
                          // 1. Fetch all rows for this specific Employee ID
                          $stmt_b = $conn->prepare("SELECT branch FROM emp_details WHERE e_id = ?");
                          $stmt_b->execute([$row['e_id']]);
                          $branches = $stmt_b->fetchAll(PDO::FETCH_ASSOC);

                          foreach($branches as $br) {
                            // 2. Only show if it's NOT the current branch
                            if($_SESSION['branch'] != $br['branch']){
                                
                                // 3. Get Branch Name
                                $stmt_name = $conn->prepare("SELECT name FROM branch WHERE id = ?");
                                $stmt_name->execute([$br['branch']]);
                                $b_data = $stmt_name->fetch(PDO::FETCH_ASSOC);

                                if($b_data) {
                                    // 4. Print Badge (The 'text-wrap' class handles the side-by-side layout)
                                    echo '<span class="badge bg-secondary me-1 mb-1">'.$b_data['name'].'</span> ';
                                }
                            }
                          }
                        ?>
                        </td>
                        <td><?php echo $row['e_name'];?></td>
                        <td><?php echo $row['fname'];?></td>
                        <td><?php echo $row['designation'];?></td>
                        <td><?php echo $row['mobile_num'];?></td>
                        <td><?php echo $row['ot'];?></td>
                        <td><?php echo $row['pf'];?></td>
                        <td><?php echo $row['esi']; ?></td>
                        <td><?php echo $row['dob']; ?></td>
                        <td><?php echo $row['e_doj']; ?></td>
                        <td><?php echo $row['salary']; ?></td>
                        <td><?php echo $row['uan_no']; ?></td>
                        <td><?php echo $row['bank_ac_no']; ?></td>
                        <td><?php echo $row['esic_no']; ?></td>
                        <td>
                          <div class="invoice-action">
                            <a href="employee-details.php?id=<?php echo $row['sn'];?>" class="invoice-action-view mr-4">
                              <i class="lni lni-eye"></i>
                            </a>
                            <a href="edit-employee.php?id=<?php echo $row['e_id'];?>" class="invoice-action-edit">
                              <i class="bi bi-pencil-square"></i>
                            </a>
                            <a href="employee-left-marking.php?branch=<?php echo $row['branch'];?>&e-id=<?php echo $row['e_id'];?>&doj=<?php echo $row['e_doj'];?>" onclick="return confirm('Are you want to delete this record ?')" class="invoice-action-view mr-4" >
                              <i class="lni lni-trash"></i>
                            </a>
                          </div>
                        </td>
                    </tr>
                    <?php  $cnt=$cnt+1; }?>
				</tbody>
				<tfoot>
					<tr>
						<th>#</th>
						<th>Id No</th>
						<th>Other Branch</th>
                        <th>Employee Name</th>
                        <th>Father Name</th>
                        <th>Designation</th>
                        <th>Mobile Number</th>
                        <th>OT</th>
                        <th>PF</th>
                        <th>ESIC</th>
                        <th>Dob</th>
                        <th>Doj</th>
                        <th>Salary</th>
                        <th>UAN Number</th>
                        <th>Bank Account Number</th>
                        <th>ESIC Number</th>
                        <th>Action</th>
					</tr>
				</tfoot>
			 </table>
			</div>
		  </div>
		</div>
             

          </div>
          <!-- end page content-->
         </div>
<?php include'system/footer.php'?>