<?php
session_start();
if(empty($_SESSION['branch']) || $_SESSION['branch'] == ''){
    header("Location: index.php");
    die();
} 
require_once 'system/conn.php';

$message = "";
$msg_type = ""; // success or danger

if(isset($_POST['submit'])) {
     
    $curr_pwd = $_POST['curr_pwd'];
    $new_pwd = $_POST['new_pwd'];
    $con_new_pwd = $_POST['con_new_pwd'];
    $id = $_SESSION['branch'];

    // 1. Fetch Current Password
    $sth = $conn->prepare("SELECT password FROM `branch` WHERE id = ?");
    $sth->execute([$id]);
    $row = $sth->fetch(PDO::FETCH_ASSOC); 
    
    if($row) {
        $stored_hash = $row['password']; 

        // 2. Verify Current Password
        if(password_verify($curr_pwd, $stored_hash)) {
    
            // 3. Check if New Password Matches Confirmation
            if($new_pwd == $con_new_pwd) {
                
                // 4. Update Password
                $new_password_hash = password_hash($new_pwd, PASSWORD_DEFAULT);
                
                // Update both secure hash AND plain text (as per your requirement)
                $sql = "UPDATE `branch` SET password = :hash, pwd_original = :plain WHERE id = :id";
                $stmt = $conn->prepare($sql);
                $result = $stmt->execute([
                    ':hash' => $new_password_hash,
                    ':plain' => $new_pwd,
                    ':id' => $id
                ]);
                
                if($result){
                    $message = "Password updated successfully!";
                    $msg_type = "success";
                } else {
                    $message = "Database error. Please try again.";
                    $msg_type = "danger";
                }

            } else {
                $message = "New Password and Confirm Password do not match.";
                $msg_type = "danger";
            }
        } else {
            $message = "Current password is incorrect.";
            $msg_type = "danger";
        }
    } else {
        $message = "User not found.";
        $msg_type = "danger";
    }
}
?>
<!doctype html>
<html lang="en" class="semi-dark">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <link href="assets/css/pace.min.css" rel="stylesheet" />
    <script src="assets/js/pace.min.js"></script>
    <link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
    <link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
    <link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />

    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/bootstrap-extended.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
    <link href="assets/css/icons.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">

    <link href="assets/css/dark-theme.css" rel="stylesheet" />
    <link href="assets/css/semi-dark.css" rel="stylesheet" />
    <link href="assets/css/header-colors.css" rel="stylesheet" />

    <title>Change Password</title>
  </head>
  <body>
    
    <div class="wrapper">
      <?php include 'system/header.php' ?>

      <div class="page-content-wrapper">
        <div class="page-content">

            <div class="row">
              <div class="col-xl-9 mx-auto">
                <h6 class="mb-0 text-uppercase">Change Password</h6>
                <hr/>
                
                <?php if(!empty($message)): ?>
                    <div class="alert alert-<?php echo $msg_type; ?> alert-dismissible fade show" role="alert">
                        <?php echo $message; ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>

                <div class="card shadow-sm">
                  <div class="card-body">
                    <div class="p-4 border rounded">
                      
                      <form class="row g-3" method="post" action="">
                        
                        <div class="col-12">
                          <label class="form-label">Current Password <span class="text-danger">*</span></label>
                          <input type="password" class="form-control" name="curr_pwd" required>
                        </div>

                        <div class="col-md-6">
                          <label class="form-label">New Password <span class="text-danger">*</span></label>
                          <input type="password" class="form-control" name="new_pwd" required>
                        </div>
                        
                        <div class="col-md-6">
                          <label class="form-label">Confirm New Password <span class="text-danger">*</span></label>
                          <input type="password" class="form-control" name="con_new_pwd" required>
                        </div>
                        
                        <div class="col-12 mt-4">
                          <button class="btn btn-primary px-4" type="submit" name="submit">Update Password</button>
                        </div>

                      </form>

                    </div>
                  </div>
                </div>
                
              </div>
            </div>

        </div>
      </div>
    </div>
    
    <?php include 'system/footer.php' ?>
  </body>
</html>