<?php 
    session_start();
    // 1. Security: Block unauthorized access
    if(empty($_SESSION['branch']) || $_SESSION['branch'] == ''){
      header("Location: index.php");
      die();
    } 
    require_once 'system/conn.php';
?>
<!doctype html>
<html lang="en" class="semi-dark">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="assets/css/pace.min.css" rel="stylesheet" />
    <script src="assets/js/pace.min.js"></script>
    <link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
    <link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
    <link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
    <link href="assets/plugins/datatable/css/dataTables.bootstrap5.min.css" rel="stylesheet" />
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/bootstrap-extended.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
    <link href="assets/css/icons.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    <link href="assets/css/dark-theme.css" rel="stylesheet" />
    <link href="assets/css/semi-dark.css" rel="stylesheet" />
    <link href="assets/css/header-colors.css" rel="stylesheet" />
    <title>Current Attendance</title>
  </head>
  <body>
    <div class="wrapper">
    <?php include'system/header.php'?>
        <div class="page-content-wrapper">
         <div class="page-content">
          
          <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
             <div class="breadcrumb-title pe-3">Current Attendance for 
             <?php
                // Safe Date Calculation
                $targetDate = strtotime("first day of last month");
                $monthName = date('F', $targetDate);
                $year = date('Y', $targetDate);
                
                // We need numeric month for Database Query
                $monthNum = date('m', $targetDate); 
                
                echo "<b><span style='color:#FF0000'>".$monthName." ".$year."</span></b>";
             ?>
             </div>
             <div class="ms-auto">
                 <a href="excel-attendance-raw.php" class="btn btn-primary px-5" style="margin-top: 5px;">Raw Attn. Excel</a>
                 <a href="excel-attendance.php" class="btn btn-primary px-5" style="margin-top: 5px;">Attn. Summary Excel</a>
             </div>
          </div>
            <hr/>
            
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="example2" class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th>SR No</th>
                                    <th>Id No</th>
                                    <th>Employee Name</th>
                                    <th>Designation</th>
                                    <th>Site</th>
                                    <th>Attendance</th>
                                    <th>Only OT</th>
                                    <th>Cheque</th>
                                    <th>Hold</th>
                                    <th>Adv. Dedct.</th>
                                    <th>Spc. Allow.</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php
                                $branch = $_SESSION['branch'];
                                $cnt = 1;

                                // ---------------------------------------------------------
                                // PERFORMANCE FIX: USE JOIN (1 Query instead of N+1)
                                // ---------------------------------------------------------
                                // We join 'attendance' with 'emp_details' and 'site'
                                // We strictly filter by Branch and Date in the main query
                                $sql = "SELECT 
                                            a.id as record_id,
                                            a.emp_id, 
                                            a.attendance, 
                                            a.only_ot, 
                                            a.check, 
                                            a.block, 
                                            a.advance_deduction, 
                                            a.spc_allow,
                                            e.e_name, 
                                            e.designation, 
                                            e.sn as emp_pk,
                                            s.name as site_name 
                                        FROM attendance a
                                        LEFT JOIN emp_details e ON a.emp_id = e.e_id AND e.branch = a.branch
                                        LEFT JOIN site s ON a.site = s.id
                                        WHERE a.month = :month 
                                          AND a.year = :year 
                                          AND a.branch = :branch";

                                $stmt = $conn->prepare($sql);
                                $stmt->execute([
                                    ':month'  => $monthNum, 
                                    ':year'   => $year, 
                                    ':branch' => $branch
                                ]);
                                
                                while($row = $stmt->fetch(PDO::FETCH_ASSOC)) 
                                { 
                            ?>
                                <tr>
                                    <td><?php echo $cnt;?></td>
                                    <td>
                                        <a href="view-details-all-emp.php?id=<?php echo htmlspecialchars($row['emp_pk']);?>">
                                            <?php echo htmlspecialchars($row['emp_id']);?>
                                        </a>
                                    </td>
                                    <td><?php echo htmlspecialchars($row['e_name'] ?? 'Unknown'); ?></td>
                                    <td><?php echo htmlspecialchars($row['designation'] ?? ''); ?></td>
                                    <td><?php echo htmlspecialchars($row['site_name'] ?? 'Unknown'); ?></td>
                                    
                                    <td><?php echo htmlspecialchars($row['attendance']);?></td>
                                    <td><?php echo htmlspecialchars($row['only_ot']);?></td>
                                    <td><?php echo htmlspecialchars($row['check']);?></td>
                                    <td><?php echo htmlspecialchars($row['block']);?></td>
                                    <td><?php echo htmlspecialchars($row['advance_deduction']);?></td>
                                    <td><?php echo htmlspecialchars($row['spc_allow']);?></td>
                                    <td>
                                        <div class="invoice-action">
                                            <a href="edit-attendace.php?id=<?php echo $row['record_id'];?>" class="invoice-action-edit">
                                              <i class="bi bi-pencil-square"></i>
                                            </a>
                                            
                                            <a href="delete-attendace.php?id=<?php echo $row['record_id']; ?>" 
                                               onclick="return confirm('Are you sure you want to delete this specific record?')" 
                                               class="invoice-action-view mr-4 text-danger">
                                                <i class="bi bi-trash"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            <?php $cnt++; } ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>SR No</th>
                                    <th>Id No</th>
                                    <th>Employee Name</th>
                                    <th>Designation</th>
                                    <th>Site</th>
                                    <th>Attendance</th>
                                    <th>Only OT</th>
                                    <th>Cheque</th>
                                    <th>Hold</th>
                                    <th>Adv. Dedct.</th>
                                    <th>Spc. Allow.</th>
                                    <th>Action</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>

         </div>
         </div>
    <?php include'system/footer.php'?>