<?php 
session_start();
if(empty($_SESSION['branch']) || $_SESSION['branch'] == ''){
    header("Location: index.php");
    die();
}
require_once 'system/conn.php';
require_once 'system/helper.php'; 

if(isset($_GET['id'])){
    // Fetch Employee
    $sth = $conn->prepare("SELECT * FROM `emp_details` WHERE sn=? ");
    $sth->execute([$_GET['id']]);
    $row = $sth->fetch(PDO::FETCH_ASSOC);

    if(!$row){
        echo "<script>alert('Employee not found or ID is invalid.'); window.location.href='all-employees.php';</script>";
        die();
    }

    // Determine Primary Branch
    $stmt_prim = $conn->prepare("SELECT sn, branch FROM `emp_details` WHERE e_id=? ORDER BY sn ASC LIMIT 1");
    $stmt_prim->execute([$row['e_id']]);
    $primary_data = $stmt_prim->fetch(PDO::FETCH_ASSOC);
    $primary_sn = $primary_data['sn'] ?? 0; 

    $is_primary_view = ($row['sn'] == $primary_sn);
}

// --- DISPLAY HELPER FUNCTIONS ---

// 1. Basic Value Cleaner
function val($value) {
    if (empty($value) && $value !== '0' && $value !== 0) {
        return ''; 
    }
    return htmlspecialchars($value);
}

// 2. Advanced Display with Styling
function display_data($value) {
    if (empty($value) && $value !== '0' && $value !== 0) {
        return '<span class="text-danger fw-bold" style="font-size: 13px;">Not Available</span>';
    }
    return '<span class="text-dark fw-bold">' . htmlspecialchars($value) . '</span>';
}
?>
<!doctype html>
<html lang="en" class="semi-dark">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="assets/css/pace.min.css" rel="stylesheet" />
    <script src="assets/js/pace.min.js"></script>
    <link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
    <link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
    <link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/bootstrap-extended.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
    <link href="assets/css/icons.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    <link href="assets/css/dark-theme.css" rel="stylesheet" />
    <link href="assets/css/semi-dark.css" rel="stylesheet" />
    <link href="assets/css/header-colors.css" rel="stylesheet" />
    
    <title>Employee Details : <?php echo htmlspecialchars($row['e_name']); ?></title>
    
    <style>
        /* --- PROFESSIONAL STYLING --- */
        body {
            background-color: #f0f2f5;
        }
        
        /* Section Headings */
        .section-header {
            color: #2c3e50;
            font-weight: 700;
            font-size: 16px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            border-bottom: 2px solid #e9ecef;
            padding-bottom: 10px;
            margin-bottom: 20px;
        }

        /* Labels */
        .data-label {
            font-size: 11px;
            text-transform: uppercase;
            color: #6c757d;
            font-weight: 600;
            margin-bottom: 4px;
            display: block;
        }

        /* Value Containers */
        .data-box {
            background-color: #fff;
            border: 1px solid #ced4da;
            border-radius: 4px;
            padding: 8px 12px;
            min-height: 38px;
            display: flex;
            align-items: center;
        }

        /* Profile Card */
        .profile-card {
            border-top: 4px solid #2c3e50; 
        }

        /* Sidebar Items */
        .branch-item, .allowance-item {
            padding: 10px 15px;
            border-bottom: 1px solid #eee;
            transition: background 0.2s;
        }
        .branch-item:last-child, .allowance-item:last-child { border-bottom: none; }
        .branch-item.active-view { background-color: #e3f2fd; border-left: 3px solid #0d6efd; }
        
        @media print {
            body * { visibility: hidden; }
            #printable-area, #printable-area * { visibility: visible; }
            #printable-area { position: absolute; left: 0; top: 0; width: 100%; }
            .no-print { display: none !important; }
        }
    </style>
  </head>
  <body>
    
  <div class="wrapper">
    <?php include 'system/header.php' ?>

    <div class="page-content-wrapper">
      <div class="page-content">

        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3 no-print">
            <div class="breadcrumb-title pe-3">Employee Details</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="all-employees.php"><i class="bx bx-group"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo htmlspecialchars($row['e_name']); ?></li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <button class="btn btn-dark px-4" onclick="window.print()"><i class="bi bi-printer-fill"></i> Print</button>
                <a href="edit-employee.php?id=<?php echo $row['e_id']; ?>" class="btn btn-warning px-4">Edit</a>
                <a href="all-employees.php" class="btn btn-secondary px-4">Back</a>
            </div>
        </div>

        <div class="row" id="printable-area">
            
            <div class="col-xl-3 col-lg-4">
                
                <div class="card shadow-sm profile-card">
                    <div class="card-body text-center pt-4">
                        <div class="mb-3">
                             <img src="<?php echo !empty($row['profile']) ? 'assets/images/employee/'.$row['profile'] : 'https://placehold.co/200x200/000000/FFFFFF/?text=NO+IMAGE'; ?>" 
                                  class="rounded-circle shadow-sm border p-1" 
                                  width="130" height="130" 
                                  style="object-fit: cover;">
                        </div>
                        <h5 class="fw-bold mb-1"><?php echo htmlspecialchars($row['e_name']); ?></h5>
                        
                        <div class="d-grid px-4">
                            <span class="badge bg-light text-dark border py-2">ID: <?php echo htmlspecialchars($row['e_id']); ?></span>
                        </div>
                    </div>
                    
                    <div class="card-footer bg-white p-0">
                        <div class="p-2 bg-light border-bottom fw-bold text-center small text-uppercase text-secondary">
                            Branch Status
                        </div>
                        <div class="branch-list">
                            <?php
                                $stmt = $conn->prepare("
                                    SELECT e.branch, e.sn, e.status, b.name 
                                    FROM emp_details e 
                                    JOIN branch b ON e.branch=b.id 
                                    WHERE e.e_id=? 
                                    ORDER BY e.sn ASC
                                ");
                                $stmt->execute([$row['e_id']]);
                                
                                foreach($stmt->fetchAll(PDO::FETCH_ASSOC) as $br_row) {
                                    $is_primary = ($br_row['sn'] == $primary_sn);
                                    $is_current = ($br_row['sn'] == $row['sn']); 
                                    
                                    if($br_row['status'] == 1){
                                        $status_badge = '<span class="badge bg-success" style="width:50px;">Active</span>';
                                    } else {
                                        $status_badge = '<span class="badge bg-danger" style="width:50px;">Left</span>';
                                    }

                                    $primary_badge = $is_primary ? '<span class="badge bg-warning text-dark ms-1" style="font-size:10px;">PRIMARY</span>' : '';
                                    $active_class = $is_current ? 'active-view' : '';

                                    echo '
                                    <div class="branch-item '.$active_class.' d-flex justify-content-between align-items-center">
                                        <div class="text-start">
                                            <div class="fw-bold text-dark" style="font-size:13px;">'.$br_row['name'].'</div>
                                            '.$primary_badge.'
                                        </div>
                                        '.$status_badge.'
                                    </div>';
                                }
                            ?>
                        </div>
                    </div>
                </div>

                <div class="card shadow-sm mt-3">
                    <div class="card-body p-0">
                        <div class="p-2 bg-light border-bottom fw-bold text-center small text-uppercase text-secondary">
                            Allowances & Perks
                        </div>
                        <div class="list-group list-group-flush">
                            <?php 
                                $allowances = [
                                    'Overtime' => $row['ot'],
                                    'Provident Fund' => $row['pf'],
                                    'ESI' => $row['esi'],
                                    'Medical' => $row['med'],
                                    'Conveyance' => $row['con']
                                ];

                                foreach($allowances as $label => $val) {
                                    $isActive = (strtolower(trim($val)) == 'yes' || strtolower(trim($val)) == 'y');
                                    
                                    // Professional Icon Status
                                    $statusHtml = $isActive 
                                        ? '<span class="text-success fw-bold small"><i class="bi bi-check-circle-fill"></i> Yes</span>' 
                                        : '<span class="text-muted small"><i class="bi bi-circle"></i> No</span>';
                                    
                                    echo '
                                    <div class="allowance-item d-flex justify-content-between align-items-center">
                                        <span class="text-secondary fw-bold" style="font-size:13px;">'.$label.'</span>
                                        '.$statusHtml.'
                                    </div>';
                                }
                            ?>
                        </div>
                    </div>
                </div>

            </div>

            <div class="col-xl-9 col-lg-8">
                
                <div class="card shadow-sm">
                    <div class="card-body p-4">
                        <h6 class="section-header"><i class="bi bi-person-circle me-2"></i> Personal Information</h6>
                        
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="data-label">Full Name</label>
                                <div class="data-box"><?php echo display_data($row['e_name']); ?></div>
                            </div>
                            
                            <div class="col-md-6">
                                <label class="data-label">Designation</label>
                                <div class="data-box"><?php echo display_data(get_designation_name($conn, $row['designation'])); ?></div>
                            </div>

                            <div class="col-md-6">
                                <label class="data-label">Date of Joining</label>
                                <div class="data-box"><?php echo display_data($row['e_doj']); ?></div>
                            </div>
                            
                            <div class="col-md-6">
                                <label class="data-label">Current Status</label>
                                <div class="data-box">
                                    <?php 
                                        if($row['status'] == 1) {
                                            echo '<span class="text-success fw-bold"><i class="bi bi-check-circle-fill"></i> Active</span>';
                                        } else {
                                            echo '<span class="text-danger fw-bold"><i class="bi bi-x-circle-fill"></i> Left / Inactive</span>';
                                        }
                                    ?>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <label class="data-label">Father's Name</label>
                                <div class="data-box"><?php echo display_data($row['fname']); ?></div>
                            </div>
                            <div class="col-md-4">
                                <label class="data-label">Mother's Name</label>
                                <div class="data-box"><?php echo display_data($row['mname']); ?></div>
                            </div>
                            <div class="col-md-4">
                                <label class="data-label">Spouse Name</label>
                                <div class="data-box"><?php echo display_data($row['husband_wife']); ?></div>
                            </div>
                            
                            <div class="col-md-4">
                                <label class="data-label">Date of Birth</label>
                                <div class="data-box"><?php echo display_data($row['dob']); ?></div>
                            </div>
                            <div class="col-md-4">
                                <label class="data-label">Mobile Number</label>
                                <div class="data-box"><?php echo display_data($row['mobile_num']); ?></div>
                            </div>
                            <div class="col-md-4">
                                <label class="data-label">Alt. Mobile</label>
                                <div class="data-box"><?php echo display_data($row['alt_mob_no']); ?></div>
                            </div>

                            <div class="col-12">
                                <label class="data-label">Address</label>
                                <div class="data-box h-auto"><?php echo display_data($row['addr']); ?></div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card shadow-sm mt-3">
                    <div class="card-body p-4">
                        <h6 class="section-header"><i class="bi bi-bank2 me-2"></i> Financial & Statutory</h6>

                        <div class="row g-3">
                            <div class="col-md-4">
                                <label class="data-label">Aadhar Number</label>
                                <div class="data-box"><?php echo display_data($row['aadhar_num']); ?></div>
                            </div>
                            <div class="col-md-4">
                                <label class="data-label">PAN Number</label>
                                <div class="data-box"><?php echo display_data($row['pan_card']); ?></div>
                            </div>
                            <div class="col-md-4">
                                <label class="data-label">UAN Number</label>
                                <div class="data-box"><?php echo display_data($row['uan_no']); ?></div>
                            </div>

                            <div class="col-md-4">
                                <label class="data-label">Bank Name</label>
                                <div class="data-box"><?php echo display_data($row['bank_name']); ?></div>
                            </div>
                            <div class="col-md-4">
                                <label class="data-label">Account No</label>
                                <div class="data-box"><?php echo display_data($row['bank_ac_no']); ?></div>
                            </div>
                            <div class="col-md-4">
                                <label class="data-label">IFSC Code</label>
                                <div class="data-box"><?php echo display_data($row['bank_ifsc']); ?></div>
                            </div>

                            <div class="col-md-6">
                                <label class="data-label">ESIC Number</label>
                                <div class="data-box"><?php echo display_data($row['esic_no']); ?></div>
                            </div>
                            <div class="col-md-6">
                                <label class="data-label">Gross Salary</label>
                                <div class="data-box border-success bg-light-success">
                                    <span class="text-success fw-bold">₹ <?php echo val($row['salary']); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="mt-3 text-end text-muted no-print">
                    <small>Last Updated: <?php echo htmlspecialchars($row['updated_date']); ?></small>
                </div>

            </div>
        </div>

      </div>
    </div>
  </div>

  <?php include 'system/footer.php'; ?>
  </body>
</html>