<?php
session_start();
require_once 'system/conn.php';
$date=explode('-',date("Y-m-d", strtotime("last day of previous month")));
$month=$date[1];
$year=$date[0];


$monthNum  =$month;
$dateObj   = DateTime::createFromFormat('!m', $monthNum);
$monthName = strtoupper($dateObj->format('F'));

$query=$conn->prepare("SELECT name FROM branch WHERE id=:param");
$query->bindParam(':param', $_SESSION['branch']);
$query->execute();
$result = $query -> fetch(PDO::FETCH_ASSOC);
$br=$result['name'];
// CREATE PHPSPREADSHEET OBJECT
require "excel_test/vendor/autoload.php";
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// CREATE A NEW SPREADSHEET + POPULATE DATA
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();
$spreadsheet->getActiveSheet()->mergeCells('A1:H1');
$spreadsheet->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);



$styleArray = [
    'font' => [
        'bold' => true,
    ],
    'alignment' => [
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
    ],
    'fill' => [
        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_GRADIENT_LINEAR,
        'rotation' => 90,
        'startColor' => [
            'argb' => 'FFA0A0A0',
        ],
        'endColor' => [
            'argb' => 'FFFFFFFF',
        ],
    ],
];
$styleArray1 = [
    'font' => [
        'bold' => true,
    ],
    'alignment' => [
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
    ],
];

$spreadsheet->getActiveSheet()->getStyle('A3:P3')->applyFromArray($styleArray1);
$spreadsheet->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);



$sheet->setTitle('Attendance sheet');
$date=$_GET['f'];
$date2=$_GET['t'];
$stmt = $conn->prepare(" SELECT emp_details.e_name, advance.amount, advance.manual_balance, advance.remaining_amount, advance.date FROM `advance` LEFT JOIN `emp_details` ON advance.e_id=emp_details.e_id AND advance.branch=emp_details.branch WHERE advance.date BETWEEN '".$date."' and '".$date2."' and advance.status= 1 and advance.branch='".$_SESSION['branch']."' ");
//print_r($stmt);exit;  
$stmt->execute();
$a = 1;
$i = 4;
  $sheet->setCellValue('A1', $br.' SITE EMPLOYEE ADVANCE SHEET '.strtoupper($monthName).' '. $year);
  $sheet->setCellValue('A3', 'SR NO');
  $sheet->setCellValue('B3', 'EMP ID');
  $sheet->setCellValue('C3', 'NAME');
  $sheet->setCellValue('D3', 'DATE');
  $sheet->setCellValue('E3', 'ADVANCE TAKEN');
  $sheet->setCellValue('F3', 'AMOUNT DEDUCT');
  $sheet->setCellValue('G3', 'AMOUNT LEFT');

   
while ($row = $stmt->fetch(PDO::FETCH_NAMED)) {
  $sheet->setCellValue('A'.$i, $a);
  $sheet->setCellValue('B'.$i, $row['e_id']);
  $sheet->setCellValue('C'.$i, $row['e_name']);
  $sheet->setCellValue('D'.$i, $row['date']);
  $sheet->setCellValue('E'.$i, $row['amount']);
  $sheet->setCellValue('F'.$i, $row['manual_balance']);
  $sheet->setCellValue('G'.$i, $row['remaining_amount']);

  $i++;
  $a++;
}

$spreadsheet->getActiveSheet()->getStyle('A'.$i.':H'.$i)->applyFromArray($styleArray1);


// OUTPUT
$writer = new Xlsx($spreadsheet);
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
// header('Content-Disposition: attachment;filename="Advance.xlsx"');
header('Content-Disposition: attachment; filename="Previous Advance Employee (Branch - ' . $br . ').xlsx"');
header('Cache-Control: max-age=0');
header('Expires: Fri, 11 Nov 2011 11:11:11 GMT');
header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
header('Cache-Control: cache, must-revalidate');
header('Pragma: public');
$writer->save('php://output');
?>