<?php
session_start();
require_once 'system/conn.php';
$date=explode('-',date("Y-m-d", strtotime("last day of previous month")));
$month=$date[1];
$year=$date[0];


$monthNum  =$month;
$dateObj   = DateTime::createFromFormat('!m', $monthNum);
$monthName = strtoupper($dateObj->format('F'));

$query=$conn->prepare("SELECT name FROM branch WHERE id=:param");
$query->bindParam(':param', $_SESSION['branch']);
$query->execute();
$result = $query -> fetch(PDO::FETCH_ASSOC);
$br=$result['name'];
// CREATE PHPSPREADSHEET OBJECT
require "excel_test/vendor/autoload.php";
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// CREATE A NEW SPREADSHEET + POPULATE DATA
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();
$spreadsheet->getActiveSheet()->mergeCells('A1:R1');
$spreadsheet->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('L')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('M')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('N')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('O')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('P')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('Q')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('R')->setAutoSize(true);


$styleArray = [
    'font' => [
        'bold' => true,
    ],
    'alignment' => [
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
    ],
    'fill' => [
        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_GRADIENT_LINEAR,
        'rotation' => 90,
        'startColor' => [
            'argb' => 'FFA0A0A0',
        ],
        'endColor' => [
            'argb' => 'FFFFFFFF',
        ],
    ],
];
$styleArray1 = [
    'font' => [
        'bold' => true,
    ],
    'alignment' => [
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
    ],
];

$spreadsheet->getActiveSheet()->getStyle('A3:R3')->applyFromArray($styleArray1);
$spreadsheet->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);



$sheet->setTitle('Gross sheet');
$stmt = $conn->prepare("SELECT emp_salary.emp_id, emp_salary.name, emp_salary.designation, emp_salary.attendance, emp_salary.basic_pay, emp_salary.hra, emp_salary.convyance, emp_salary.medical, emp_salary.spc_allow, emp_salary.gross_pay, emp_salary.pf, emp_salary.esic, emp_salary.advance, emp_salary.tax, emp_salary.deduction, emp_salary.net_pay, emp_details.uan_no, emp_details.esic_no  from emp_salary  LEFT JOIN emp_details ON emp_salary.emp_id=emp_details.e_id AND emp_salary.branch=emp_details.branch WHERE emp_salary.branch='".$_SESSION['branch']."' AND emp_salary.month='$month' AND emp_salary.year='$year' UNION SELECT '', 'z', 'TOTAL', SUM(attendance), SUM(basic_pay), SUM(hra), SUM(convyance), SUM(medical), SUM(spc_allow), SUM(gross_pay), SUM(pf), SUM(esic), SUM(advance), SUM(tax), SUM(deduction), SUM(net_pay), '', '' from emp_salary where `branch`='".$_SESSION['branch']."' and `month`='$month' and `year`='$year' ORDER BY name ASC");

    
$stmt->execute();
$a = 1;
$i = 4;
  $sheet->setCellValue('A1', $br.' WAGE SHEET FOR THE '.$monthName.' '. $year);
  $sheet->setCellValue('A3', 'SR NO');
  $sheet->setCellValue('B3', 'NAME');
  $sheet->setCellValue('C3', 'DESIGNATION');
  $sheet->setCellValue('D3', 'EMP ID');
  $sheet->setCellValue('E3', 'UAN-NO');
  $sheet->setCellValue('F3', 'ATTENDENCE');
  $sheet->setCellValue('G3', 'BASIC PAY');
  $sheet->setCellValue('H3', 'HRA');
  $sheet->setCellValue('I3', 'ESIC NO');
  $sheet->setCellValue('J3', 'MEDICAL');
  $sheet->setCellValue('K3', 'SPC. ALLOWANCE');
  $sheet->setCellValue('L3', 'GROSS');
  $sheet->setCellValue('M3', 'PF');
  $sheet->setCellValue('N3', 'ESIC');
  $sheet->setCellValue('O3', 'ADVANCE');
  $sheet->setCellValue('P3', 'TAX');
  $sheet->setCellValue('Q3', 'DEDUCTION');
  $sheet->setCellValue('R3', 'NET-PAY');
   
while ($row = $stmt->fetch(PDO::FETCH_NAMED)) {
  $sheet->setCellValue('A'.$i, $a);
  $sheet->setCellValue('B'.$i, $row['name']);
  $sheet->setCellValue('C'.$i, $row['designation']);
  $sheet->setCellValue('D'.$i, $row['emp_id']);
  $sheet->setCellValue('E'.$i, $row['uan_no']);
  $sheet->setCellValue('F'.$i, $row['attendance']);
  $sheet->setCellValue('G'.$i, $row['basic_pay']);
  $sheet->setCellValue('H'.$i, $row['hra']);
  $sheet->setCellValue('I'.$i, $row['esic_no']);
  $sheet->setCellValue('J'.$i, $row['medical']);
  $sheet->setCellValue('K'.$i, $row['spc_allow']);
  $sheet->setCellValue('L'.$i, $row['gross_pay']);
  $sheet->setCellValue('M'.$i, $row['pf']);
  $sheet->setCellValue('N'.$i, $row['esic']);
  $sheet->setCellValue('O'.$i, $row['advance']);
  $sheet->setCellValue('P'.$i, $row['tax']);
  $sheet->setCellValue('Q'.$i, $row['deduction']);
  $sheet->setCellValue('R'.$i, $row['net_pay']);
  $i++;
  $a++;
}

$spreadsheet->getActiveSheet()->getStyle('A'.$i.':R'.$i)->applyFromArray($styleArray1);


// OUTPUT
$writer = new Xlsx($spreadsheet);
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="Gross Employee (Branch - ' . $br . ').xlsx"');
header('Cache-Control: max-age=0');
header('Expires: Fri, 11 Nov 2011 11:11:11 GMT');
header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . 'GMT');
header('Cache-Control: cache, must-revalidate');
header('Pragma: public');
$writer->save('php://output');
?>