<?php
session_start();
require_once 'system/conn.php';
$date=explode('-',date("Y-m-d", strtotime("last day of previous month")));
$month=$date[1];
$year=$date[0];


$monthNum  =$month;
$dateObj   = DateTime::createFromFormat('!m', $monthNum);
$monthName = strtoupper($dateObj->format('F'));


$query=$conn->prepare("SELECT name FROM branch WHERE id=:param");
$query->bindParam(':param', $_SESSION['branch']);
$query->execute();
$result = $query -> fetch(PDO::FETCH_ASSOC);
$br=$result['name'];
// CREATE PHPSPREADSHEET OBJECT
require "excel_test/vendor/autoload.php";
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// CREATE A NEW SPREADSHEET + POPULATE DATA
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();
$spreadsheet->getActiveSheet()->mergeCells('A1:H1');
$spreadsheet->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
$spreadsheet->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);


$styleArray = [
    'font' => [
        'bold' => true,
    ],
    'alignment' => [
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
    ],
    'fill' => [
        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_GRADIENT_LINEAR,
        'rotation' => 90,
        'startColor' => [
            'argb' => 'FFA0A0A0',
        ],
        'endColor' => [
            'argb' => 'FFFFFFFF',
        ],
    ],
];
$styleArray1 = [
    'font' => [
        'bold' => true,
    ],
    'alignment' => [
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
    ],
];

$spreadsheet->getActiveSheet()->getStyle('A3:H3')->applyFromArray($styleArray1);
$spreadsheet->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);



$sheet->setTitle('Temporary Emp sheet');
$stmt = $conn->prepare("SELECT emp_salary.emp_id, emp_salary.name, emp_salary.designation, emp_salary.ac_no, emp_details.salary, emp_details.e_doj from emp_salary  LEFT JOIN emp_details ON emp_salary.emp_id=emp_details.e_id AND emp_salary.branch=emp_details.branch WHERE emp_salary.branch='".$_SESSION['branch']."' AND emp_salary.month='$month' AND emp_salary.year='$year' ORDER BY name ASC");

    
$stmt->execute();
$a = 1;
$i = 4;
  $sheet->setCellValue('A1', $br.' Salary Calulation Temporary Sheet '.$monthName.' '. $year);
  $sheet->setCellValue('A3', 'SR NO');
  $sheet->setCellValue('B3', 'NAME');
  $sheet->setCellValue('C3', 'DESIGNATION');
  $sheet->setCellValue('D3', 'EMP ID');
  $sheet->setCellValue('E3', 'A/C NO');
  $sheet->setCellValue('F3', 'PAY SALARY');
  $sheet->setCellValue('G3', 'PER DAY SAL');
  $sheet->setCellValue('H3', 'DATE OF JOINING');
  
while ($row = $stmt->fetch(PDO::FETCH_NAMED)) {
    $pds=$row['salary']/26;
    $doj = date("d-m-Y", strtotime($row['e_doj']));
  $sheet->setCellValue('A'.$i, $a);
  $sheet->setCellValue('B'.$i, $row['name']);
  $sheet->setCellValue('C'.$i, $row['designation']);
  $sheet->setCellValue('D'.$i, $row['emp_id']);
  $sheet->setCellValue('E'.$i, ' '. $row['ac_no']);
  $sheet->setCellValue('F'.$i, $row['salary']);
  $sheet->setCellValue('G'.$i, $pds);
  $sheet->setCellValue('H'.$i, $doj);
  
  $i++;
  $a++;
}

$spreadsheet->getActiveSheet()->getStyle('A'.$i.':H'.$i)->applyFromArray($styleArray1);


// OUTPUT
$writer = new Xlsx($spreadsheet);
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="temp_salary.xlsx"');
header('Cache-Control: max-age=0');
header('Expires: Fri, 11 Nov 2011 11:11:11 GMT');
header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
header('Cache-Control: cache, must-revalidate');
header('Pragma: public');
$writer->save('php://output');
?>