<?php 
    session_start();
    if(empty($_SESSION['branch']) || $_SESSION['branch'] == ''){
        header("Location: index.php");
        die();
    }
    require_once 'system/conn.php';
    
    // Get Years of Experience
    $target_experience = isset($_POST['ex']) ? (int)$_POST['ex'] : 0;
    
    // Get Target Date (Defaults to Today if empty)
    $target_date_str = isset($_POST['exp_date']) && !empty($_POST['exp_date']) ? $_POST['exp_date'] : date('Y-m-d');
?>
<!doctype html>
<html lang="en" class="semi-dark">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <link href="assets/css/pace.min.css" rel="stylesheet" />
    <script src="assets/js/pace.min.js"></script>
    <link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
    <link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
    <link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
    <link href="assets/plugins/datatable/css/dataTables.bootstrap5.min.css" rel="stylesheet" />
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/bootstrap-extended.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
    <link href="assets/css/icons.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    <link href="assets/css/dark-theme.css" rel="stylesheet" />
    <link href="assets/css/semi-dark.css" rel="stylesheet" />
    <link href="assets/css/header-colors.css" rel="stylesheet" />
    
    <title><?php echo $target_experience; ?> Year Of Employee Experience</title>
  </head>
  <body>
    <div class="wrapper">
    <?php include 'system/header.php' ?>
        <div class="page-content-wrapper">
            <div class="page-content">
                
                <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
                    <div class="breadcrumb-title pe-3">
                        <?php echo $target_experience; ?> Year Experience (As of <?php echo date('d-m-Y', strtotime($target_date_str)); ?>)
                    </div>
                    <div class="ms-auto">
                        <a href="excel-experience.php?ex=<?php echo $target_experience; ?>&date=<?php echo $target_date_str; ?>">
                            <button type="button" class="btn btn-primary px-5">Excel Download</button>
                        </a>
                    </div>
                </div>
                <hr/>
                
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="example2" class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Id No</th>
                                        <th style="width: 15%;">Other Branch</th>
                                        <th>Employee Name</th>
                                        <th>Doj</th>
                                        <th>Designation</th>
                                        <th>Mobile Number</th>
                                        <th>Dob</th>
                                        <th>Salary</th>
                                        <th>UAN Number</th>
                                        <th>Bank Account Number</th>
                                        <th>Details</th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php
                                $i = 1;
                                
                                // LOGIC UPDATE: Use the selected date ($target_date_str) instead of current date
                                $calculationDate = new DateTime($target_date_str);

                                $query = $conn->prepare("SELECT * FROM `emp_details` WHERE branch = ? AND status='1'");
                                $query->execute([$_SESSION['branch']]);

                                while ($result = $query->fetch(PDO::FETCH_ASSOC)) {
                                    
                                    $rawDate = trim($result['e_doj']);
                                    $rawDate = rtrim($rawDate, '-');

                                    // Robust Date Parsing
                                    $dateObj = false;
                                    if (strpos($rawDate, '/') !== false) {
                                        $dateObj = DateTime::createFromFormat('d/m/Y', $rawDate);
                                    } elseif (strpos($rawDate, '-') !== false) {
                                        $dateObj = DateTime::createFromFormat('Y-m-d', $rawDate);
                                    }

                                    if (!$dateObj) continue; 

                                    // Calculate diff between DOJ and Selected Calculation Date
                                    $years_exp = $calculationDate->diff($dateObj)->y;

                                    if ($years_exp == $target_experience) {
                                ?>
                                    <tr>
                                        <td><?php echo $i++; ?></td>
                                        
                                        <td>
                                            <a href="view-details-all-emp.php?id=<?php echo $result['sn']; ?>">
                                                <?php echo $result['e_id']; ?>
                                            </a>
                                        </td>
                                        
                                        <td class="text-wrap">
                                        <?php
                                            $stmt_b = $conn->prepare("SELECT branch FROM emp_details WHERE e_id = ?");
                                            $stmt_b->execute([$result['e_id']]);
                                            $branches = $stmt_b->fetchAll(PDO::FETCH_ASSOC);

                                            foreach($branches as $br) {
                                                if($_SESSION['branch'] != $br['branch']){
                                                    $stmt_name = $conn->prepare("SELECT name FROM branch WHERE id = ?");
                                                    $stmt_name->execute([$br['branch']]);
                                                    $b_data = $stmt_name->fetch(PDO::FETCH_ASSOC);

                                                    if($b_data) {
                                                        echo '<span class="badge bg-secondary me-1 mb-1">'.$b_data['name'].'</span> ';
                                                    }
                                                }
                                            }
                                        ?>
                                        </td>

                                        <td><?php echo $result['e_name']; ?></td>
                                        <td><?php echo $result['e_doj']; ?></td>
                                        <td><?php echo $result['designation']; ?></td>
                                        <td><?php echo $result['mobile_num']; ?></td>
                                        <td><?php echo $result['dob']; ?></td>
                                        <td><?php echo $result['salary']; ?></td>
                                        <td><?php echo $result['uan_no']; ?></td>
                                        <td><?php echo $result['bank_ac_no']; ?></td>

                                        <td class="text-center">
                                            <a href="employee-details.php?id=<?php echo $result['sn']; ?>" class="btn btn-primary btn-sm px-3">
                                                <i class="bi bi-eye"></i> View
                                            </a>
                                        </td>
                                    </tr>
                                <?php
                                    }
                                }
                                ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>#</th>
                                        <th>Id No</th>
                                        <th>Other Branch</th>
                                        <th>Employee Name</th>
                                        <th>Doj</th>
                                        <th>Designation</th>
                                        <th>Mobile Number</th>
                                        <th>Dob</th>
                                        <th>Salary</th>
                                        <th>UAN Number</th>
                                        <th>Bank Account Number</th>
                                        <th>Details</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    <?php include 'system/footer.php' ?>
    </div>
  </body>
</html>