<?php 
  session_start();
  if(empty($_SESSION['branch']) || $_SESSION['branch'] == ''){
    header("Location: index.php");
    die();
  }
  require_once 'system/conn.php';
?>
<!doctype html>
<html lang="en" class="semi-dark">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="assets/css/pace.min.css" rel="stylesheet" />
    <script src="assets/js/pace.min.js"></script>
    <link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
    <link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
    <link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
    <link href="assets/plugins/datatable/css/dataTables.bootstrap5.min.css" rel="stylesheet" />
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/bootstrap-extended.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
    <link href="assets/css/icons.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    <link href="assets/css/dark-theme.css" rel="stylesheet" />
    <link href="assets/css/semi-dark.css" rel="stylesheet" />
    <link href="assets/css/header-colors.css" rel="stylesheet" />
    <title>Experience Report Selection</title>
  </head>
  <body>
    <div class="wrapper">
    <?php include 'system/header.php' ?>
      <div class="page-content-wrapper">
         <div class="page-content">
          <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">Employee Experience Report</div>
          </div>
          <hr/>

            <div class="row">
              <div class="col-xl-9 mx-auto"> <div class="card shadow-sm border-0">
                  <div class="card-body">
                    <div class="p-4 border rounded">
                      
                      <form action="experience-data.php" method="post">
                        
                        <div class="row g-3">
                            
                            <div class="col-md-6">
                                <label class="form-label fw-bold">Years Of Experience:</label>
                                <select class="form-select" name="ex" required>
                                  <option value="">--- Select Years ---</option>
                                  <option value="1">1 Year</option>
                                  <option value="2">2 Years</option>
                                  <option value="3">3 Years</option>
                                  <option value="4">4 Years</option>
                                  <option value="5">More Than 5 Years</option>
                                </select>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-bold">Experience As On:</label>
                                <input type="date" class="form-control" name="exp_date" value="<?php echo date('Y-m-d'); ?>" required>
                                <div class="form-text">Calculates experience up to this date.</div>
                            </div>

                            <div class="col-12 text-center mt-4">
                                <button type="submit" name="submit" value="submit" class="btn btn-primary px-5">
                                    <i class="bi bi-search"></i> Generate Report
                                </button>
                            </div>

                        </div>

                      </form>    
                    </div>
                  </div>
                </div>
                
              </div>
            </div>
            </div>
          </div>

<?php include 'system/footer.php' ?>