<?php

require "vendor/autoload.php";


use Spipu\Html2Pdf\Html2Pdf;
use Spipu\Html2Pdf\Exception\Html2PdfException;
use Spipu\Html2Pdf\Exception\ExceptionFormatter;

$data =1;

try {
    $html2pdf = new Html2Pdf('p', '', 'fr', true, 'UTF-8', array(0, 0, 0, 0));
    $html2pdf->pdf->SetDisplayMode('fullpage');
    ob_start();
    include 'sample2.php';
    $content = ob_get_clean();
    $html2pdf->writeHTML($content);
    error_reporting(0);
    $html2pdf->createIndex('', 30, 12, false, true, 1, "helvetica");
    $html2pdf->output(  substr($data , 0, 20). '.pdf');
} catch (Html2PdfException $e) {
    $formatter = new ExceptionFormatter($e);
    echo $formatter->getHtmlMessage();
}
// ---------|---------|-------------
// $html2pdf->createIndex($titre, $sizeTitle, $sizeBookmark, $bookmarkTitle, $displayPage, $onPage, $fontName);
// $title | Index | index title
// $sizeTitle | 20 | font size of the index title, in mm
// $sizeBookmark | 15 | font size of the index, in mm
// $bookmarkTitle | true | add a bookmark for the index, at his beginning
// $displayPage | true | display the page numbers
// $onPage | null | if null : at the end of the document on a new page, else on the $onPage page
// $fontName | helvetica | font name to use