<?php 
  session_start();
  if(empty($_SESSION['branch']) || $_SESSION['branch'] == ''){
    header("Location: index.php");
    die();
  }
  require_once 'system/conn.php';

  // 1. Centralized Date Logic
  $dateObj = new DateTime('first day of last month');
  $month     = $dateObj->format('m');
  $year      = $dateObj->format('Y');
  $monthName = $dateObj->format('F');
  $branch_id = $_SESSION['branch'];
?>
<!doctype html>
<html lang="en" class="semi-dark">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <link href="assets/css/pace.min.css" rel="stylesheet" />
    <script src="assets/js/pace.min.js"></script>
    <link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
    <link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
    <link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
    <link href="assets/plugins/datatable/css/dataTables.bootstrap5.min.css" rel="stylesheet" />
    
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/bootstrap-extended.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
    <link href="assets/css/icons.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    
    <link href="assets/css/dark-theme.css" rel="stylesheet" />
    <link href="assets/css/semi-dark.css" rel="stylesheet" />
    <link href="assets/css/header-colors.css" rel="stylesheet" />
    
    <title>Current Gross Sheet (<?php echo "$monthName-$year"; ?>)</title>
  </head>
  <body>
    <div class="wrapper">
    <?php include 'system/header.php' ?>
      <div class="page-content-wrapper">
         <div class="page-content">
          
          <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">
                Current Gross Sheet (<?php echo "$monthName-$year"; ?>)
            </div>
            <div class="ms-auto">
                <a href="delete-salary.php" class="btn btn-danger px-5" onclick="return confirm('Are you sure you want to delete all salary data for this month?')">Delete Salary</a>
                <a href="salary-process-ui.php" class="btn btn-success px-5" onclick="return confirm('Are you sure you want to generate salary?')">Generate Salary</a>
                
                <?php if($branch_id == 21){ ?>
                  <a href="excel21.php" class="btn btn-primary px-5">Excel Download</a>
                <?php } else { ?>
                  <a href="excel11.php" class="btn btn-primary px-5">Excel Download</a>
                <?php } ?>
            </div>
          </div>

          <div class="col-sm-12">
              <?php if(isset($_SESSION['delete'])){ ?>
              <div class="alert alert-dismissible fade show py-2 bg-danger">
                <div class="d-flex align-items-center">
                  <div class="fs-3 text-white"><ion-icon name="close-circle-sharp"></ion-icon></div>
                  <div class="ms-3">
                    <div class="text-white"><b><?php echo $_SESSION['delete']; ?></b></div>
                  </div>
                </div>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
              </div>
              <?php unset($_SESSION['delete']); } ?>

              <?php if(isset($_SESSION['s_sa'])){ ?>
              <div class="alert alert-dismissible fade show py-2 bg-danger">
                <div class="d-flex align-items-center">
                  <div class="fs-3 text-white"><ion-icon name="close-circle-sharp"></ion-icon></div>
                  <div class="ms-3">
                    <div class="text-white"><b><?php echo $_SESSION['s_sa']; ?></b></div>
                  </div>
                </div>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
              </div>
              <?php unset($_SESSION['s_sa']); } ?>
          </div>
          <hr/>

          <div class="card">
            <div class="card-body">
              <div class="table-responsive">
                <table id="example2" class="table table-striped table-bordered text-start">
                    <thead>
                        <tr class="text-start">
                            <th>#</th>
                            <th>Employee Name</th>
                            <th>Designation</th>
                            <th>Employee Code</th>
                            <th>UAN Number</th>
                            <th>Paid Days</th>
                            <th>Basic Pay</th>
                            <th>HRA</th>
                            <th>Spc. Allowance</th>
                            <th>Gross Pay</th>
                            <th>PF</th>
                            <th>Esic</th>
                            <th>Staff Adv.</th>
                            <th>Professional Tax</th>
                            <th>Total Deduction</th>
                            <th>Net Pay</th>
                        </tr>
                    </thead>
                    <tbody>
                      <?php
                        $cnt = 1;
                        
                        $sql = "
                            SELECT 
                                s.emp_id, s.name, s.designation, s.attendance, s.basic_pay, 
                                s.hra, s.convyance, s.medical, s.spc_allow, s.gross_pay, 
                                s.pf, s.esic, s.advance, s.tax, s.deduction, s.net_pay, 
                                d.uan_no 
                            FROM emp_salary s
                            LEFT JOIN emp_details d ON s.emp_id = d.e_id AND s.branch = d.branch 
                            WHERE s.branch = :branch1 AND s.month = :month1 AND s.year = :year1 
                            
                            UNION 
                            
                            SELECT 
                                '', 'z', 'TOTAL', SUM(attendance), SUM(basic_pay), 
                                SUM(hra), SUM(convyance), SUM(medical), SUM(spc_allow), SUM(gross_pay), 
                                SUM(pf), SUM(esic), SUM(advance), SUM(tax), SUM(deduction), SUM(net_pay), 
                                '' 
                            FROM emp_salary 
                            WHERE branch = :branch2 AND month = :month2 AND year = :year2 
                            
                            ORDER BY name ASC
                        ";

                        $stmt = $conn->prepare($sql);
                        $stmt->execute([
                            ':branch1' => $branch_id,
                            ':month1'  => $month,
                            ':year1'   => $year,
                            ':branch2' => $branch_id,
                            ':month2'  => $month,
                            ':year2'   => $year
                        ]);

                        while($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                      ?>
                        <tr class="text-start">
                            <td><?php echo $cnt;?></td>
                            <td><?php echo htmlspecialchars($row['name']);?></td>
                            <td><?php echo htmlspecialchars($row['designation']);?></td>
                            <td><?php echo htmlspecialchars($row['emp_id']);?></td>
                            <td><?php echo htmlspecialchars($row['uan_no']);?></td>
                            <td><?php echo $row['attendance'];?></td>
                            <td><?php echo $row['basic_pay'];?></td>
                            <td><?php echo $row['hra'];?></td>
                            <td><?php echo $row['spc_allow'];?></td>
                            <td class="fw-bold"><?php echo $row['gross_pay'];?></td>
                            <td><?php echo $row['pf'];?></td>
                            <td><?php echo $row['esic'];?></td>
                            <td><?php echo $row['advance'];?></td>
                            <td><?php echo $row['tax'];?></td>
                            <td><?php echo $row['deduction'];?></td>
                            <td class="fw-bold text-primary"><?php echo $row['net_pay'];?></td>    
                        </tr>
                      <?php 
                          $cnt++; 
                        } 
                      ?>
                    </tbody>
                    <tfoot>
                        <tr class="text-start">
                            <th>#</th>
                            <th>Employee Name</th>
                            <th>Designation</th>
                            <th>Employee Code</th>
                            <th>UAN Number</th>
                            <th>Paid Days</th>
                            <th>Basic Pay</th>
                            <th>HRA</th>
                            <th>Spc. Allowance</th>
                            <th>Gross Pay</th>
                            <th>PF</th>
                            <th>Esic</th>
                            <th>Staff Adv.</th>
                            <th>Professional Tax</th>
                            <th>Total Deduction</th>
                            <th>Net Pay</th>
                        </tr>
                    </tfoot>
                </table>
              </div>
            </div>
          </div>

         </div>
      </div>
      <?php include 'system/footer.php' ?>
    </div>
  </body>
</html>