<?php
// -------------------------------------------------------------------------
// 1. INITIALIZATION & DATA FETCHING
// -------------------------------------------------------------------------
session_start();
if(empty($_SESSION['branch']) || $_SESSION['branch'] == ''){
    header("Location: index.php");
    die();
}
require_once 'system/conn.php';

$branch_id = $_SESSION['branch'];
$current_date = date('Y-m-d');

// -- Dates for Salary Cycle (Previous Month) --
$prev_month_obj = DateTime::createFromFormat('Y-m-d', date('Y-m-01', strtotime("-1 month")));
$process_month_num = $prev_month_obj->format('m');
$process_month_name = $prev_month_obj->format('F');
$process_year = $prev_month_obj->format('Y');

// -- Dates for New Employees (Last Month) --
$start_date_new_emp = date('Y-m-01', strtotime("-1 month")); 

// -------------------------------------------------------------------------
// 2. DASHBOARD STATISTICS QUERIES
// -------------------------------------------------------------------------

// A. Employee Stats
// -----------------
// 1. Active Employees
$stmt = $conn->prepare("SELECT count(*) FROM emp_details WHERE status=1 AND branch=?");
$stmt->execute([$branch_id]);
$cnt_active = $stmt->fetchColumn();

// 2. New Joinees
$stmt = $conn->prepare("SELECT count(*) FROM emp_details WHERE e_doj BETWEEN ? AND ? AND status='1' AND branch=?");
$stmt->execute([$start_date_new_emp, $current_date, $branch_id]);
$cnt_new = $stmt->fetchColumn();

// 3. Left Employees
$stmt = $conn->prepare("SELECT count(e.e_id) FROM emp_details e 
                        LEFT JOIN left_employee l ON e.e_id = l.emp_id AND e.branch = l.branch 
                        WHERE e.status='0' AND e.branch=? AND l.status='1'");
$stmt->execute([$branch_id]);
$cnt_left = $stmt->fetchColumn();

// 4. Sites
$stmt = $conn->prepare("SELECT count(*) FROM site WHERE branch=?");
$stmt->execute([$branch_id]);
$cnt_sites = $stmt->fetchColumn();


// B. Salary Sheet Status (Count & Sum)
// ------------------------------------
// We fetch COUNT (for records) and SUM (for value) in one go for efficiency.

// 1. Gross Sheet
$stmt = $conn->prepare("SELECT count(*) as cnt, SUM(net_pay) as val FROM emp_salary WHERE branch=? AND month=? AND year=?");
$stmt->execute([$branch_id, $process_month_num, $process_year]);
$gross_data = $stmt->fetch(PDO::FETCH_ASSOC);

// 2. Bank Sheet
$stmt = $conn->prepare("SELECT count(*) as cnt, SUM(net_pay) as val FROM emp_salary WHERE branch=? AND month=? AND year=? AND block='' AND cheque='' AND ac_no!=''");
$stmt->execute([$branch_id, $process_month_num, $process_year]);
$bank_data = $stmt->fetch(PDO::FETCH_ASSOC);

// 3. Cheque Sheet
$stmt = $conn->prepare("SELECT count(*) as cnt, SUM(net_pay) as val FROM emp_salary WHERE branch=? AND month=? AND year=? AND (cheque='yes' OR ac_no='')");
$stmt->execute([$branch_id, $process_month_num, $process_year]);
$cheque_data = $stmt->fetch(PDO::FETCH_ASSOC);

// 4. Hold Sheet
$stmt = $conn->prepare("SELECT count(*) as cnt, SUM(net_pay) as val FROM emp_salary WHERE branch=? AND month=? AND year=? AND block='yes'");
$stmt->execute([$branch_id, $process_month_num, $process_year]);
$hold_data = $stmt->fetch(PDO::FETCH_ASSOC);


// C. OT Salary Status
// -------------------
// 1. OT Gross (Assuming table 'ot_salary' based on naming convention)
$stmt = $conn->prepare("SELECT count(*) as cnt FROM ot_details WHERE branch=? AND month=? AND year=?");
$stmt->execute([$branch_id, $process_month_num, $process_year]);
$ot_gross_data = $stmt->fetch(PDO::FETCH_ASSOC);

// 2. OT Bank
$stmt = $conn->prepare("SELECT count(*) as cnt FROM ot_details WHERE branch=? AND month=? AND year=? AND ac_no!=''");
$stmt->execute([$branch_id, $process_month_num, $process_year]);
$ot_bank_data = $stmt->fetch(PDO::FETCH_ASSOC);

?>
<!doctype html>
<html lang="en" class="semi-dark">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  
  <link href="assets/css/pace.min.css" rel="stylesheet" />
  <script src="assets/js/pace.min.js"></script>
  <link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
  <link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
  <link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
  <link href="assets/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/css/bootstrap-extended.css" rel="stylesheet">
  <link href="assets/css/style.css" rel="stylesheet">
  <link href="assets/css/icons.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css">
  <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
  <link href="assets/css/dark-theme.css" rel="stylesheet" />
  <link href="assets/css/semi-dark.css" rel="stylesheet" />
  <link href="assets/css/header-colors.css" rel="stylesheet" />
  
  <title>Dashboard - Utkal Team Care</title>

  <style>
    /* Custom Dashboard Styles */
    .info-strip {
        background: #0090e7;
        color: white;
        border-radius: 0 0 15px 15px;
        margin-top: -1.5rem;
        margin-left: -1.5rem;
        margin-right: -1.5rem;
        padding: 1rem 2rem;
        box-shadow: 0 4px 10px rgba(0, 144, 231, 0.2);
        margin-bottom: 2rem;
    }
    .card-stat {
        border: none;
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 2px 6px rgba(0,0,0,0.05);
        transition: all 0.3s ease;
        position: relative;
        overflow: hidden;
    }
    .card-stat:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 15px rgba(0,0,0,0.1);
    }
    .card-stat::after {
        content: "";
        position: absolute;
        top: 0; left: 0; width: 4px; height: 100%;
    }
    .stat-blue::after { background: #0090e7; }
    .stat-green::after { background: #15ca20; }
    .stat-red::after { background: #fd3550; }
    .stat-orange::after { background: #ff9700; }

    /* Action Buttons */
    .btn-quick-action {
        background: #fff;
        border: 1px solid #eef1f3;
        padding: 15px;
        border-radius: 10px;
        text-align: left;
        color: #343a40;
        box-shadow: 0 4px 6px rgba(0,0,0,0.04);
        transition: all 0.2s ease;
        display: flex;
        align-items: center;
        justify-content: space-between;
        font-weight: 500;
        margin-bottom: 10px;
    }
    .btn-quick-action:hover {
        background: #f8f9fa;
        border-color: #0090e7;
        color: #0090e7;
        box-shadow: 0 5px 12px rgba(0, 144, 231, 0.15);
        transform: scale(1.01);
    }
    .btn-quick-action .icon-wrap {
        width: 40px; height: 40px; border-radius: 8px; 
        display: flex; align-items: center; justify-content: center;
        margin-right: 15px; font-size: 1.2rem;
    }

    /* Table Styles */
    .table-section-header {
        background-color: #f1f4f6;
        color: #5f6e7c;
        font-size: 0.85rem;
        text-transform: uppercase;
        letter-spacing: 1px;
        font-weight: 600;
    }
    .badge-soft-success { background-color: rgba(21, 202, 32, 0.1); color: #15ca20; }
    .badge-soft-danger { background-color: rgba(253, 53, 80, 0.1); color: #fd3550; }
    .badge-soft-secondary { background-color: rgba(108, 117, 125, 0.1); color: #6c757d; }
  </style>
</head>
<body>

  <div class="wrapper">
    <?php include'system/header.php'?>

    <div class="page-content-wrapper">
      <div class="page-content">

        <div class="info-strip d-flex align-items-center justify-content-between flex-wrap gap-2">
            <div>
                <h5 class="mb-0 text-white"><i class="bi bi-speedometer2 me-2"></i>Dashboard</h5>
                <small style="opacity: 0.8;">Overview & Statistics</small>
            </div>
            
            <div class="d-flex gap-4 text-end">
                <div>
                    <small class="d-block text-uppercase" style="font-size: 10px; opacity:0.8;">Processing Month</small>
                    <span class="fw-bold fs-5"><?php echo $process_month_name . ' ' . $process_year; ?></span>
                </div>
                <div class="border-start border-white ps-4" style="opacity: 0.5;"></div>
                <div>
                    <small class="d-block text-uppercase" style="font-size: 10px; opacity:0.8;">Today</small>
                    <span class="fw-bold"><?php echo date('d M Y'); ?></span>
                </div>
            </div>
        </div>

        <div class="row row-cols-1 row-cols-md-2 row-cols-xl-4 g-3 mb-4">
            
            <div class="col">
                <div class="card-stat stat-blue p-3 h-100 d-flex align-items-center">
                    <div class="flex-grow-1">
                        <p class="text-muted mb-1 small text-uppercase">Active Employees</p>
                        <h2 class="mb-0 text-dark"><?php echo $cnt_active; ?></h2>
                        <a href="all-employees.php" class="small text-primary text-decoration-none">View List &rarr;</a>
                    </div>
                    <div class="icon-wrap bg-light-primary text-primary p-3 rounded-circle">
                        <i class="bi bi-people fs-4"></i>
                    </div>
                </div>
            </div>

            <div class="col">
                <div class="card-stat stat-green p-3 h-100 d-flex align-items-center">
                    <div class="flex-grow-1">
                        <p class="text-muted mb-1 small text-uppercase">New Joinees</p>
                        <h2 class="mb-0 text-dark"><?php echo $cnt_new; ?></h2>
                        <a href="new-employees.php" class="small text-success text-decoration-none">Check List &rarr;</a>
                    </div>
                    <div class="icon-wrap bg-light-success text-success p-3 rounded-circle">
                        <i class="bi bi-person-plus fs-4"></i>
                    </div>
                </div>
            </div>

            <div class="col">
                <div class="card-stat stat-red p-3 h-100 d-flex align-items-center">
                    <div class="flex-grow-1">
                        <p class="text-muted mb-1 small text-uppercase">Resigned / Left</p>
                        <h2 class="mb-0 text-dark"><?php echo $cnt_left; ?></h2>
                        <a href="left-employees.php" class="small text-danger text-decoration-none">History &rarr;</a>
                    </div>
                    <div class="icon-wrap bg-light-danger text-danger p-3 rounded-circle">
                        <i class="bi bi-person-x fs-4"></i>
                    </div>
                </div>
            </div>

            <div class="col">
                <div class="card-stat stat-orange p-3 h-100 d-flex align-items-center">
                    <div class="flex-grow-1">
                        <p class="text-muted mb-1 small text-uppercase">Total Sites</p>
                        <h2 class="mb-0 text-dark"><?php echo $cnt_sites; ?></h2>
                        <a href="site-list.php" class="small text-warning text-dark text-decoration-none">Manage &rarr;</a>
                    </div>
                    <div class="icon-wrap bg-light-warning text-warning p-3 rounded-circle">
                        <i class="bi bi-building fs-4"></i>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            
            <div class="col-12 col-xl-8">
                <div class="card shadow-sm radius-10 border-0">
                    <div class="card-header bg-white border-bottom py-3">
                        <h5 class="mb-0 text-primary">Salary Sheet Availability</h5>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table align-middle mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>Sheet Name</th>
                                        <th class="text-center">Status</th>
                                        <th class="text-center">Records Found</th>
                                        <th class="text-end">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    
                                    <tr class="table-section-header">
                                        <td colspan="4"><i class="bi bi-calendar-check me-2"></i>Regular Salary (<?php echo $process_month_name; ?>)</td>
                                    </tr>

                                    <tr>
                                        <td>Gross Salary Sheet</td>
                                        <td class="text-center"><?php echo ($gross_data['cnt'] > 0) ? '<span class="badge badge-soft-success">Generated</span>' : '<span class="badge badge-soft-secondary">Pending</span>'; ?></td>
                                        <td class="text-center fw-bold"><?php echo $gross_data['cnt']; ?></td>
                                        <td class="text-end"><a href="gross-sheet.php" class="btn btn-sm btn-light text-primary">View</a></td>
                                    </tr>

                                    <tr>
                                        <td>Bank Transfer Sheet</td>
                                        <td class="text-center"><?php echo ($bank_data['cnt'] > 0) ? '<span class="badge badge-soft-success">Generated</span>' : '<span class="badge badge-soft-secondary">Pending</span>'; ?></td>
                                        <td class="text-center fw-bold"><?php echo $bank_data['cnt']; ?></td>
                                        <td class="text-end"><a href="bank-sheet.php" class="btn btn-sm btn-light text-primary">View</a></td>
                                    </tr>

                                    <tr>
                                        <td>Cheque/Cash Sheet</td>
                                        <td class="text-center"><?php echo ($cheque_data['cnt'] > 0) ? '<span class="badge badge-soft-success">Generated</span>' : '<span class="badge badge-soft-secondary">Pending</span>'; ?></td>
                                        <td class="text-center fw-bold"><?php echo $cheque_data['cnt']; ?></td>
                                        <td class="text-end"><a href="cheque-sheet.php" class="btn btn-sm btn-light text-primary">View</a></td>
                                    </tr>

                                    <tr>
                                        <td>Hold Salary Sheet</td>
                                        <td class="text-center"><?php echo ($hold_data['cnt'] > 0) ? '<span class="badge badge-soft-danger">On Hold</span>' : '<span class="badge badge-soft-secondary">None</span>'; ?></td>
                                        <td class="text-center fw-bold"><?php echo $hold_data['cnt']; ?></td>
                                        <td class="text-end"><a href="hold-sheet.php" class="btn btn-sm btn-light text-primary">View</a></td>
                                    </tr>

                                    <tr class="table-section-header">
                                        <td colspan="4"><i class="bi bi-clock-history me-2"></i>Overtime (OT) Salary</td>
                                    </tr>

                                    <tr>
                                        <td>OT Gross Sheet</td>
                                        <td class="text-center"><?php echo ($ot_gross_data['cnt'] > 0) ? '<span class="badge badge-soft-success">Generated</span>' : '<span class="badge badge-soft-secondary">Pending</span>'; ?></td>
                                        <td class="text-center fw-bold"><?php echo $ot_gross_data['cnt']; ?></td>
                                        <td class="text-end"><a href="ot-gross-sheet.php" class="btn btn-sm btn-light text-primary">View</a></td>
                                    </tr>

                                    <tr>
                                        <td>OT Bank Sheet</td>
                                        <td class="text-center"><?php echo ($ot_bank_data['cnt'] > 0) ? '<span class="badge badge-soft-success">Generated</span>' : '<span class="badge badge-soft-secondary">Pending</span>'; ?></td>
                                        <td class="text-center fw-bold"><?php echo $ot_bank_data['cnt']; ?></td>
                                        <td class="text-end"><a href="ot-bank-sheet.php" class="btn btn-sm btn-light text-primary">View</a></td>
                                    </tr>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-12 col-xl-4">
                <h5 class="text-dark mb-3">Quick Actions</h5>
                
                <a href="add-employee.php" class="btn-quick-action">
                    <div class="d-flex align-items-center">
                        <div class="icon-wrap bg-light-primary text-primary"><i class="bi bi-person-plus-fill"></i></div>
                        <span>Add New Employee</span>
                    </div>
                    <i class="bi bi-chevron-right text-muted"></i>
                </a>

                <a href="payment-entry.php" class="btn-quick-action">
                    <div class="d-flex align-items-center">
                        <div class="icon-wrap bg-light-success text-success"><i class="bi bi-wallet2"></i></div>
                        <span>Payment Entry</span>
                    </div>
                    <i class="bi bi-chevron-right text-muted"></i>
                </a>

                <a href="issue-advance.php" class="btn-quick-action">
                    <div class="d-flex align-items-center">
                        <div class="icon-wrap bg-light-warning text-warning"><i class="bi bi-cash-coin"></i></div>
                        <span>Issue Advance</span>
                    </div>
                    <i class="bi bi-chevron-right text-muted"></i>
                </a>

                <a href="salary-slip.php" class="btn-quick-action">
                    <div class="d-flex align-items-center">
                        <div class="icon-wrap bg-light-danger text-danger"><i class="bi bi-file-earmark-pdf-fill"></i></div>
                        <span>Download Salary Slips</span>
                    </div>
                    <i class="bi bi-chevron-right text-muted"></i>
                </a>

                <div class="card mt-4 bg-dark text-white radius-10 border-0" style="background: linear-gradient(45deg, #343a40, #212529);">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="fs-1 me-3"><i class="bi bi-archive"></i></div>
                            <div>
                                <h6 class="mb-1 text-white">Archives</h6>
                                <p class="mb-2 small opacity-75">Access previous months data.</p>
                                <a href="previous-salary.php" class="btn btn-sm btn-light px-3 rounded-pill text-dark">Go to Archive</a>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>

      </div>
    </div>
  </div>

  <?php include'system/footer.php'?>
</body>
</html>