<?php 
    session_start();
    if(empty($_SESSION['branch']) || $_SESSION['branch'] == ''){
        header("Location: index.php");
        die();
    }
    require_once 'system/conn.php';
?>
<!doctype html>
<html lang="en" class="semi-dark">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
    <link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
    <link href="assets/plugins/datatable/css/dataTables.bootstrap5.min.css" rel="stylesheet" />
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/bootstrap-extended.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
    <link href="assets/css/icons.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    <link href="assets/css/dark-theme.css" rel="stylesheet" />
    <link href="assets/css/semi-dark.css" rel="stylesheet" />
    <link href="assets/css/header-colors.css" rel="stylesheet" />
    
    <title>Left Employees List</title>
  </head>
  <body>
    <div class="wrapper">
    <?php include 'system/header.php' ?>
        <div class="page-content-wrapper">
            <div class="page-content">
                
                <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
                    <div class="breadcrumb-title pe-3">Left Employees List</div>
                    <div class="ms-auto">
                        <a href="excel-left-employees.php" class="btn btn-primary px-4"><i class="bi bi-file-earmark-excel"></i> Excel Download</a>
                    </div>
                </div>
                <hr/>
                
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="example2" class="table table-striped table-bordered align-middle">
                                <thead class="table-light">
                                    <tr>
                                        <th>#</th>
                                        <th>Emp ID</th>
                                        <th>Left Date</th>
                                        <th>Join Date</th>
                                        <th>Employee Name</th>
                                        <th>Designation</th>
                                        <th>Father Name</th>
                                        <th>Mobile</th>
                                        <th>Adhar Number</th>
                                        <th>Salary</th>
                                        <th>Account</th>
                                        <th style="width: 150px;">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $cnt = 1;
                                    $stmt = $conn->prepare("
                                        SELECT 
                                            e.sn, e.e_id, e.e_name, e.fname, e.mobile_num, e.alt_mob_no, 
                                            e.aadhar_num, e.pan_card, e.designation, e.salary, e.bank_ac_no,
                                            l.d_o_l, l.entry_date, l.id as left_id
                                        FROM emp_details e 
                                        LEFT JOIN left_employee l ON e.e_id = l.emp_id AND e.branch = l.branch 
                                        WHERE e.status='0' AND e.branch=? AND l.status='1'
                                    ");
                                    $stmt->execute([$_SESSION['branch']]);
                                    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

                                    foreach($rows as $row) { 
                                    ?>
                                    <tr>
                                        <td class="py-1"><?php echo $cnt;?></td>
                                        <td class="py-1">
                                            <span class="fw-bold text-primary"><?php echo htmlspecialchars($row['e_id']);?></span>
                                        </td>
                                        
                                        <td class="py-1"><span class="badge bg-light-danger text-danger border border-danger"><?php echo date("d-m-Y", strtotime($row['d_o_l'])); ?></span></td>
                                        <td class="py-1"><?php echo date("d-m-Y", strtotime($row['entry_date'])); ?></td>
                                        
                                        <td class="py-1"><?php echo htmlspecialchars($row['e_name']);?></td>
                                        <td class="py-1"><?php echo htmlspecialchars($row['designation']);?></td>
                                        <td class="py-1"><?php echo htmlspecialchars($row['fname']);?></td> 
                                        <td class="py-1"><?php echo htmlspecialchars($row['mobile_num']);?></td> 
                                        <td class="py-1"><?php echo htmlspecialchars($row['aadhar_num']);?></td> 
                                        
                                        <td class="py-1"><?php echo htmlspecialchars($row['salary']);?></td>
                                        <td class="py-1"><?php echo htmlspecialchars($row['bank_ac_no']);?></td> 
                                        <td class="py-1">
                                            <div class="d-flex gap-2">
                                                
                                                <a href="employee-details.php?id=<?php echo $row['sn'];?>" 
                                                   class="btn btn-sm btn-primary text-white py-0 px-2" 
                                                   style="font-size: 13px;"
                                                   data-bs-toggle="tooltip" 
                                                   data-bs-placement="top" 
                                                   title="View Details">
                                                    <i class="bi bi-eye-fill"></i> View
                                                </a>

                                                <a href="rejoin-emp.php?id=<?php echo $row['e_id'];?>&ldate=<?php echo $row['d_o_l'];?>&uid=<?php echo $row['sn'];?>&sn_id=<?php echo $row['left_id'];?>" 
                                                   class="btn btn-sm btn-success text-white py-0 px-2" 
                                                   style="font-size: 13px;"
                                                   onclick="return confirm('Are you sure you want to rejoin this employee?');"
                                                   data-bs-toggle="tooltip" 
                                                   data-bs-placement="top" 
                                                   title="Rejoin Employee">
                                                    <i class="bi bi-arrow-counterclockwise"></i> Rejoin
                                                </a>

                                            </div>
                                        </td>
                                    </tr>
                                    <?php $cnt++; } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    <?php include 'system/footer.php' ?>
    </div>

    <script src="assets/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/jquery.min.js"></script>
    <script src="assets/plugins/simplebar/js/simplebar.min.js"></script>
    <script src="assets/plugins/metismenu/js/metisMenu.min.js"></script>
    <script src="assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
    <script src="assets/js/pace.min.js"></script>
    <script src="assets/plugins/datatable/js/jquery.dataTables.min.js"></script>
    <script src="assets/plugins/datatable/js/dataTables.bootstrap5.min.js"></script>
    <script src="assets/js/app.js"></script>
  </body>
</html>