<?php
/**
 * salary_persist.php
 * Bulk inserts salary rows into emp_salary
 */

function persistSalaries(
    PDO $conn,
    array $salaryRows
): int {

    if (empty($salaryRows)) {
        throw new Exception("No salary rows to insert.");
    }

    $columns = [
        'name','designation','ac_no','emp_id','month','year','attendance','t_at',
        'basic_pay','hra','convyance','medical','gross_pay','pf','esic',
        'advance','tax','spc_allow','deduction','net_pay',
        'block','cheque','branch','payment_status'
    ];

    $placeholders = [];
    $values = [];

    foreach ($salaryRows as $row) {
        $rowPlaceholders = [];
        foreach ($columns as $col) {
            $rowPlaceholders[] = '?';
            $values[] = $row[$col];
        }
        $placeholders[] = '(' . implode(',', $rowPlaceholders) . ')';
    }

    $sql = "
        INSERT INTO emp_salary (" . implode(',', $columns) . ")
        VALUES " . implode(',', $placeholders);

    $stmt = $conn->prepare($sql);
    $stmt->execute($values);

    return $stmt->rowCount();
}
