<?php 
// ot-gross-sheet.php
session_start();
if(empty($_SESSION['branch']) || $_SESSION['branch'] == ''){
    header("Location: index.php");
    die();
} 
require_once 'system/conn.php';

// Centralized Date Logic (Target: Previous Month)
$dateObj = new DateTime('first day of last month');
$month   = $dateObj->format('m');
$year    = $dateObj->format('Y');
$monthName = $dateObj->format('F');
$branch  = $_SESSION['branch'];
?>
<!doctype html>
<html lang="en" class="semi-dark">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="assets/css/pace.min.css" rel="stylesheet" />
    <script src="assets/js/pace.min.js"></script>
    <link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
    <link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
    <link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
    <link href="assets/plugins/datatable/css/dataTables.bootstrap5.min.css" rel="stylesheet" />
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/bootstrap-extended.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
    <link href="assets/css/icons.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    <link href="assets/css/dark-theme.css" rel="stylesheet" />
    <link href="assets/css/semi-dark.css" rel="stylesheet" />
    <link href="assets/css/header-colors.css" rel="stylesheet" />
    <title>OT Gross Sheet (<?php echo $monthName;?>-<?php echo $year;?>)</title>
</head>
<body>
    <div class="wrapper">
    <?php include 'system/header.php'; ?>
        <div class="page-content-wrapper">
            <div class="page-content">
                <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
                    <div class="breadcrumb-title pe-3">
                        OT Gross Sheet (<?php echo $monthName;?>-<?php echo $year;?>)
                    </div>
                    <div class="ms-auto">
                        <a href="excel-ot-gross-sheet.php" class="btn btn-primary px-5" style="margin-top: 5px;">Excel download</a>
                    </div>
                </div>
                <hr/>
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="example2" class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th>SR No</th>
                                        <th>Employee Name</th>
                                        <th>Employee Id</th>
                                        <th>Designation</th>
                                        <th>Paid Days</th>
                                        <th>Net Pay</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    // Fetch pre-generated OT details using PDO Prepared Statements
                                    $stmt = $conn->prepare("
                                        SELECT emp_name, designation, emp_id, ot_days, amount 
                                        FROM ot_details 
                                        WHERE branch = ? AND month = ? AND year = ?
                                        ORDER BY emp_name ASC
                                    ");
                                    $stmt->execute([$branch, $month, $year]);
                                    
                                    $cnt = 1;
                                    $hasData = false;
                                    
                                    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                                        $hasData = true;
                                    ?>
                                        <tr>
                                            <td><?php echo $cnt; ?></td>
                                            <td><?php echo $row['emp_name']; ?></td>
                                            <td><?php echo $row['emp_id']; ?></td>
                                            <td><?php echo $row['designation']; ?></td>
                                            <td><?php echo $row['ot_days']; ?></td>
                                            <td><?php echo $row['amount']; ?></td>
                                        </tr>
                                    <?php 
                                        $cnt++; 
                                    } 

                                    if (!$hasData) {
                                        echo '<tr><td colspan="6" class="text-center">No OT Records Available for '.$monthName.'-'.$year.'</td></tr>';
                                    }
                                    ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>SR No</th>
                                        <th>Employee Name</th>
                                        <th>Employee Id</th>
                                        <th>Designation</th>
                                        <th>Paid Days</th>
                                        <th>Net Pay</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            </div>
    </div>
<?php include 'system/footer.php'; ?>