<?php 
  session_start();
  if(empty($_SESSION['branch']) || $_SESSION['branch'] == ''){
    header("Location: index.php");
    die();
  }
  require_once 'system/conn.php';

  // 1. Centralized Date Logic
  // Check POST first, then SESSION (fixes redirect loop)
  $year  = $_POST['year']  ?? $_SESSION['archive_year'] ?? null;
  $month = $_POST['month'] ?? $_SESSION['archive_month'] ?? null;
  $branch_id = $_SESSION['branch'];

  if(!$year || !$month){
      header("Location: previous-salary.php");
      exit();
  }

  $dateObj   = DateTime::createFromFormat('!m', $month);
  $monthName = $dateObj->format('F');
?>
<!doctype html>
<html lang="en" class="semi-dark">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <link href="assets/css/pace.min.css" rel="stylesheet" />
    <script src="assets/js/pace.min.js"></script>
    <link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
    <link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
    <link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
    <link href="assets/plugins/datatable/css/dataTables.bootstrap5.min.css" rel="stylesheet" />
    
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/bootstrap-extended.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
    <link href="assets/css/icons.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    
    <link href="assets/css/dark-theme.css" rel="stylesheet" />
    <link href="assets/css/semi-dark.css" rel="stylesheet" />
    <link href="assets/css/header-colors.css" rel="stylesheet" />
    
    <title>Previous OT Gross Sheet (<?php echo "$monthName-$year"; ?>)</title>
  </head>
  <body>
    <div class="wrapper">
    <?php include 'system/header.php' ?>
      <div class="page-content-wrapper">
         <div class="page-content">
          
          <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">
                Previous OT Gross Sheet (<?php echo "$monthName-$year"; ?>)
            </div>
            <div class="ms-auto">
                <a href="excel-p-ot-gross-sheet.php?m=<?php echo $month; ?>&y=<?php echo $year; ?>" class="btn btn-primary px-5" style="margin-top: 5px;">Excel download</a>
            </div>
          </div>
          <hr/>

          <div class="card">
            <div class="card-body">
              <div class="table-responsive">
                <table id="example2" class="table table-striped table-bordered text-start">
                    <thead>
                        <tr>
                            <th>SR No</th>
                            <th>Employee Name</th>
                            <th>Designation</th>
                            <th>Employee Id</th>
                            <th>OT Days</th>
                            <th>Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                      <?php
                        $cnt = 1;
                        
                        // UNION QUERY
                        // Note: Using lowercase 'designation' to be safe.
                        // Assuming 'emp_name' is correct based on your previous code.
                        $sql = "
                            SELECT emp_name, designation, emp_id, ot_days, amount
                            FROM prv_ot_details
                            WHERE branch = :branch1 
                              AND month = :month1 
                              AND year = :year1
                            
                            UNION
                            
                            SELECT 'z', 'TOTAL', '', SUM(ot_days), SUM(amount)
                            FROM prv_ot_details
                            WHERE branch = :branch2
                              AND month = :month2
                              AND year = :year2
                            
                            ORDER BY emp_name ASC
                        ";

                        $stmt = $conn->prepare($sql);
                        $stmt->execute([
                            ':branch1' => $branch_id, ':month1' => $month, ':year1' => $year,
                            ':branch2' => $branch_id, ':month2' => $month, ':year2' => $year
                        ]);

                        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);

                        // NO DATA CHECK
                        // If results only contain the 'z TOTAL' row (with NULLs), consider it empty.
                        $hasData = false;
                        foreach($results as $chk) {
                            if ($chk['emp_name'] !== 'z TOTAL') {
                                $hasData = true;
                                break;
                            }
                        }

                        if (!$hasData) {
                      ?>
                        <tr>
                            <td colspan="6" class="text-center text-danger fw-bold">No Data Found</td>
                        </tr>
                      <?php
                        } else {
                            foreach($results as $row) {
                                $isTotal = ($row['emp_name'] == 'z TOTAL');
                      ?>
                        <tr>
                            <td><?php echo $isTotal ? '' : $cnt; ?></td>
                            
                            <td><?php echo $isTotal ? '<strong>z TOTAL</strong>' : htmlspecialchars($row['emp_name']);?></td>
                            
                            <td><?php echo $isTotal ? '<strong>TOTAL</strong>' : htmlspecialchars($row['designation']);?></td>
                            
                            <td><?php echo htmlspecialchars($row['emp_id']);?></td>
                            
                            <td class="<?php echo $isTotal ? 'fw-bold' : ''; ?>">
                                <?php echo $row['ot_days']; ?>
                            </td>
                            
                            <td class="<?php echo $isTotal ? 'fw-bold text-primary' : ''; ?>">
                                <?php echo round($row['amount']); ?>
                            </td>
                        </tr>
                      <?php 
                                if(!$isTotal) $cnt++; 
                            }
                        } 
                      ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <th>SR No</th>
                            <th>Employee Name</th>
                            <th>Designation</th>
                            <th>Employee Id</th>
                            <th>OT Days</th>
                            <th>Amount</th>
                        </tr>
                    </tfoot>
                </table>
              </div>
            </div>
          </div>

         </div>
      </div>
      <?php include 'system/footer.php' ?>
    </div>
  </body>
</html>