<?php 
  session_start();
  if(empty($_SESSION['branch']) || $_SESSION['branch'] == ''){
    header("Location: index.php");
    die();
  }
  require_once 'system/conn.php';
?>
<!doctype html>
<html lang="en" class="semi-dark">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="assets/css/pace.min.css" rel="stylesheet" />
    <script src="assets/js/pace.min.js"></script>
    <link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
    <link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
    <link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
    <link href="assets/plugins/datatable/css/dataTables.bootstrap5.min.css" rel="stylesheet" />
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/bootstrap-extended.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
    <link href="assets/css/icons.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    <link href="assets/css/dark-theme.css" rel="stylesheet" />
    <link href="assets/css/semi-dark.css" rel="stylesheet" />
    <link href="assets/css/header-colors.css" rel="stylesheet" />
    <title>Previous Attendance (<?php echo $_POST['year'].' - '.$_POST['month'] ?>)</title>
  </head>
  <body>
    <div class="wrapper">
    <?php include'system/header.php'?>
        <div class="page-content-wrapper">
         <div class="page-content">
          <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <?php $dateObj    = DateTime::createFromFormat('!m', $_POST['month'] );
            $monthName = $dateObj->format('F'); ?>
            <div class="breadcrumb-title pe-3">Previous Attendance (<?php echo $_POST['year'].' - '.$monthName ?>)</div>
            <div class="ms-auto">
                <a href="excel-prv-attendance.php?m=<?php echo $_POST['month']?>&y=<?php echo $_POST['year']?>"><button type="button" class="btn btn-primary px-5">Excel Download</button></a>
            </div>
          </div>
            <hr/>
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="example2" class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th>SR No</th>
                                        <th>Id No</th>
                                        <th>Employee Id</th>
                                        <th>Employee Name</th>
                                        <th>Designation</th>
                                        <th>Site</th>
                                        <th>Attendance</th>
                                        <th>Only OT</th>
                                        <th>Check</th>
                                        <th>Hold</th>
                                        <th>Adv Deduction</th>
                                        <th>Special Allowance</th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php
                                    $month = $_POST['month'];
                                    $year  = $_POST['year'];
                                    $branch = $_SESSION['branch'];
                                    $cnt   = 1;

                                    // Fetch All Columns from prv_salary_attendance
                                    // JOIN with emp_details to get Name/Designation/SN
                                    $sql = "SELECT 
                                                p.id,
                                                p.emp_id,
                                                p.t_a,
                                                p.o_a,
                                                p.block,
                                                p.cheque,
                                                p.maual_advance,
                                                p.spc_allow,
                                                p.details,
                                                e.e_name,
                                                e.designation,
                                                e.sn
                                            FROM prv_salary_attendance p
                                            LEFT JOIN emp_details e ON p.emp_id = e.e_id AND p.branch = e.branch
                                            WHERE p.branch = :branch 
                                              AND p.month = :month 
                                              AND p.year = :year
                                            ORDER BY e.e_name ASC";

                                    $stmt = $conn->prepare($sql);
                                    $stmt->execute([
                                        ':branch' => $branch,
                                        ':month'  => $month,
                                        ':year'   => $year
                                    ]);
                                    
                                    $results = $stmt->fetchAll(PDO::FETCH_ASSOC);

                                    foreach ($results as $row) {
                                ?>
                                    <tr>
                                        <td><?php echo $cnt;?></td>
                                        <td>
                                            <a href="view-details-all-emp.php?id=<?php echo $row['sn'];?>"><?php echo $row['emp_id'];?></a>
                                        </td>
                                        <td><?php echo $row['emp_id']; ?></td>
                                        <td><?php echo $row['e_name']; ?></td>
                                        <td><?php echo $row['designation']; ?></td>
                                        <td><?php echo $row['details']; // Site Name is stored in 'details' ?></td>
                                        <td><?php echo $row['t_a']; // Total Attendance ?></td>
                                        <td><?php echo $row['o_a']; // Only OT ?></td>
                                        <td><?php echo $row['cheque']; // Check ?></td>
                                        <td><?php echo $row['block']; // Hold ?></td>
                                        <td><?php echo $row['maual_advance']; // Adv Deduction ?></td>
                                        <td><?php echo $row['spc_allow']; // Special Allowance ?></td>
                                    </tr>
                                <?php $cnt++; } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>SR No</th>
                                        <th>Id No</th>
                                        <th>Employee Id</th>
                                        <th>Employee Name</th>
                                        <th>Designation</th>
                                        <th>Site</th>
                                        <th>Attendance</th>
                                        <th>Only OT</th>
                                        <th>Check</th>
                                        <th>Hold</th>
                                        <th>Adv Deduction</th>
                                        <th>Special Allowance</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
              

          </div>
          </div>
<?php include'system/footer.php'?>