<?php 
  session_start();
  if(empty($_SESSION['branch']) || $_SESSION['branch'] == ''){
    header("Location: index.php");
    die();
  }
  require_once 'system/conn.php';

  // 1. Centralized Date Logic
  $year  = $_POST['year']  ?? $_SESSION['archive_year'] ?? null;
  $month = $_POST['month'] ?? $_SESSION['archive_month'] ?? null;
  $branch_id = $_SESSION['branch'];

  if(!$year || !$month){
      header("Location: previous-salary.php");
      exit();
  }

  $dateObj   = DateTime::createFromFormat('!m', $month);
  $monthName = $dateObj->format('F');
?>
<!doctype html>
<html lang="en" class="semi-dark">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <link href="assets/css/pace.min.css" rel="stylesheet" />
    <script src="assets/js/pace.min.js"></script>
    <link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
    <link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
    <link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
    <link href="assets/plugins/datatable/css/dataTables.bootstrap5.min.css" rel="stylesheet" />
    
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/bootstrap-extended.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
    <link href="assets/css/icons.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    
    <link href="assets/css/dark-theme.css" rel="stylesheet" />
    <link href="assets/css/semi-dark.css" rel="stylesheet" />
    <link href="assets/css/header-colors.css" rel="stylesheet" />
    
    <title>Previous Hold Sheet (<?php echo "$monthName-$year"; ?>)</title>
  </head>
  <body>
    <div class="wrapper">
    <?php include 'system/header.php' ?>
      <div class="page-content-wrapper">
         <div class="page-content">
          
          <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">
                Previous Hold Sheet (<?php echo "$monthName-$year"; ?>)
            </div>
            <div class="ms-auto">
                <a href="excel-previous-hold-sheet.php?m=<?php echo $month; ?>&y=<?php echo $year; ?>" class="btn btn-primary px-5">Excel Download</a>
            </div>
          </div>
          <hr/>

          <div class="card">
            <div class="card-body">
              <div class="table-responsive">
                <table id="example2" class="table table-striped table-bordered text-start">
                    <thead>
                        <tr class="text-start">
                            <th>SR No</th>
                            <th>Employee Name</th>
                            <th>Designation</th>
                            <th>Employee Code</th>
                            <th>Account No.</th>
                            <th>Net Pay</th>
                        </tr>
                    </thead>
                    <tbody>
                      <?php
                        $cnt = 1;
                        
                        // UNION QUERY:
                        // 1. Employees with block='yes'
                        // 2. 'z TOTAL' row with Sum
                        $sql = "
                            SELECT name, designation, emp_id, ac_no, net_pay
                            FROM prv_emp_salary
                            WHERE branch = :branch1 
                              AND month = :month1 
                              AND year = :year1 
                              AND block = 'yes'
                            
                            UNION
                            
                            SELECT 'Z TOTAL', '', '', '', SUM(net_pay)
                            FROM prv_emp_salary
                            WHERE branch = :branch2
                              AND month = :month2
                              AND year = :year2
                              AND block = 'yes'
                            
                            ORDER BY name ASC
                        ";

                        $stmt = $conn->prepare($sql);
                        $stmt->execute([
                            ':branch1' => $branch_id, ':month1' => $month, ':year1' => $year,
                            ':branch2' => $branch_id, ':month2' => $month, ':year2' => $year
                        ]);
                        
                        // Fetch all results to check if we have data
                        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
                        
                        // Check if there are any real employees (ignoring the Total row)
                        $hasData = false;
                        foreach($results as $chk) {
                            if ($chk['name'] !== 'z TOTAL') {
                                $hasData = true;
                                break;
                            }
                        }

                        if (!$hasData) {
                            // If no employees found, show message
                      ?>
                        <tr>
                            <td colspan="6" class="text-center text-danger fw-bold">No Data Found</td>
                        </tr>
                      <?php
                        } else {
                            // If data exists, loop and display (including Total)
                            foreach($results as $row) {
                                $isTotal = ($row['name'] == 'z TOTAL');
                      ?>
                        <tr class="text-start">
                            <td><?php echo $isTotal ? '' : $cnt; ?></td>
                            <td><?php echo $isTotal ? '<strong>z TOTAL</strong>' : htmlspecialchars($row['name']);?></td>
                            <td><?php echo $isTotal ? '<strong>TOTAL</strong>' : htmlspecialchars($row['designation']);?></td>
                            <td><?php echo htmlspecialchars($row['emp_id']);?></td>
                            <td><?php echo htmlspecialchars($row['ac_no']);?></td>
                            <td class="<?php echo $isTotal ? 'fw-bold text-primary' : ''; ?>">
                                <?php echo $row['net_pay'];?>
                            </td>    
                        </tr>
                      <?php 
                              if(!$isTotal) $cnt++; 
                            }
                        } 
                      ?>
                    </tbody>
                    <tfoot>
                        <tr class="text-start">
                            <th>SR No</th>
                            <th>Employee Name</th>
                            <th>Designation</th>
                            <th>Employee Code</th>
                            <th>Account No.</th>
                            <th>Net Pay</th>
                        </tr>
                    </tfoot>
                </table>
              </div>
            </div>
          </div>

         </div>
      </div>
      <?php include 'system/footer.php' ?>
    </div>
  </body>
</html>