<?php
session_start();

if (isset($_POST['view_report'])) {
    // 1. Capture the selections from the UI
    $type  = $_POST['sheet_type'] ?? '';
    $year  = $_POST['year'] ?? '';
    $month = $_POST['month'] ?? '';

    if (empty($type) || empty($year) || empty($month)) {
        header("Location: previous-salary.php");
        exit();
    }

    // 2. Store the date in session so the target page can use it
    $_SESSION['archive_year']  = $year;
    $_SESSION['archive_month'] = $month;

    /**
     * 3. Routing Map
     * Maps the 'sheet_type' value to the actual PHP filename.
     */
    $destinations = [
        // Main Salary Sheets
        'salary_gross'  => 'previous-gross-sheet.php',
        'salary_bank'   => 'previous-bank-sheet-data.php',
        'salary_cheque' => 'previous-cheque-sheet-data.php',
        'salary_hold'   => 'previous-hold-sheet-data.php',
        
        // OT Sheets
        'ot_gross'      => 'p-ot-gross-data.php',
        'ot_bank'       => 'p-ot-bank-data.php',
        'ot_cheque'     => 'p-ot-cheque-data.php',
        'ot_hold'       => 'p-ot-hold-data.php'
    ];

    if (array_key_exists($type, $destinations)) {
        header("Location: " . $destinations[$type]);
        exit();
    }
}

// Fallback if accessed directly
header("Location: previous-salary.php");
exit();