<?php 
  session_start();
  if(empty($_SESSION['branch']) || $_SESSION['branch'] == ''){
    header("Location: index.php");
    die();
  }
  require_once 'system/conn.php';

  // 1. Centralized Date Logic (Previous Month)
  $date = explode('-', date("Y-m-d", strtotime("last day of previous month")));
  $month = $date[1];
  $year  = $date[0];

  $monthNum  = $month;
  $dateObj   = DateTime::createFromFormat('!m', $monthNum);
  $monthName = $dateObj->format('F');
  $branch    = $_SESSION['branch'];
?>
<!doctype html>
<html lang="en" class="semi-dark">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
	<link href="assets/css/pace.min.css" rel="stylesheet" />
	<script src="assets/js/pace.min.js"></script>
    <link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
    <link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
    <link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
    <link href="assets/plugins/datatable/css/dataTables.bootstrap5.min.css" rel="stylesheet" />
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/bootstrap-extended.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
    <link href="assets/css/icons.css" rel="stylesheet">
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    <link href="assets/css/dark-theme.css" rel="stylesheet" />
    <link href="assets/css/semi-dark.css" rel="stylesheet" />
    <link href="assets/css/header-colors.css" rel="stylesheet" />
    <title>Current Professional Tax Sheet (<?php echo $monthName;?>-<?php echo $year;?>)</title>
  </head>
  <body>
    <div class="wrapper">
    <?php include'system/header.php'?>
	    <div class="page-content-wrapper">
         <div class="page-content">
          <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">
                Current Professional Tax Sheet (<?php echo $monthName;?>-<?php echo $year;?>)
            </div>
            <div class="ms-auto">
                <a href="excel-professional-tax.php" class="btn btn-primary px-5">Excel download</a>
                <!-- <?php  if($branch == 21){ ?>
                  <a href="professional-tax-excel21.php" class="btn btn-primary px-5">Excel download</a>
                <?php } else { ?>
                  <a href="professional-tax-excel11.php" class="btn btn-primary px-5">Excel download</a>
                <?php } ?> -->
            </div>
          </div>
          <div class="col-sm-12">
              <?php if(isset($_SESSION['delete'])){?>
              <div class="alert alert-dismissible fade show py-2 bg-danger">
                <div class="d-flex align-items-center">
                  <div class="fs-3 text-white"><i class="bi bi-x-circle-fill"></i></div>
                  <div class="ms-3">
                    <div class="text-white"><b><?php echo $_SESSION['delete'];?></b></div>
                  </div>
                </div>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
              </div>
              <?php }?>
              <?php if(isset($_SESSION['s_sa'])){?>
              <div class="alert alert-dismissible fade show py-2 bg-danger">
                <div class="d-flex align-items-center">
                  <div class="fs-3 text-white"><i class="bi bi-x-circle-fill"></i></div>
                  <div class="ms-3">
                    <div class="text-white"><b><?php echo $_SESSION['s_sa'];?></b></div>
                  </div>
                </div>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
              </div>
              <?php }?>
          </div>
			<hr/>
			<div class="card">
			  <div class="card-body">
				<div class="table-responsive">
				  <table id="example2" class="table table-striped table-bordered">
					<thead>
						<tr>
							<th>SR No</th>
				 			<th>Employee Name</th>
                            <th>Designation</th>
                            <th>Employee Code</th>
                            <th>Gross Pay</th>
                            <th>Professional Tax</th>
						</tr>
					</thead>
					<tbody>
						<?php
                            $cnt = 1;
                            // 2. Fixed UNION Query with placeholders and 'z' sorting hack
                            $stmt1 = $conn->prepare("
                                SELECT 
                                    emp_salary.emp_id, 
                                    emp_salary.name, 
                                    emp_salary.designation, 
                                    emp_salary.gross_pay, 
                                    emp_salary.tax 
                                FROM emp_salary  
                                WHERE emp_salary.branch = ? AND emp_salary.month = ? AND emp_salary.year = ? 
                                
                                UNION ALL

                                SELECT 
                                    '', 
                                    'z', 
                                    'TOTAL', 
                                    SUM(gross_pay), 
                                    SUM(tax) 
                                FROM emp_salary 
                                WHERE branch = ? AND month = ? AND year = ?

                                ORDER BY name ASC
                            ");

                            $stmt1->execute([$branch, $month, $year, $branch, $month, $year]);

                            while ($row = $stmt1->fetch(PDO::FETCH_ASSOC)) { 
                                $isTotal = ($row['name'] === 'z');
                        ?>
						<tr>
							<td><?php echo $cnt;?></td>
							<td><?php echo $isTotal ? '' : $row['name'];?></td>
							<td><?php echo $row['designation']?></td>
							<td><?php echo $row['emp_id']?></td>
							<td><?php echo $row['gross_pay'];?></td>
							<td><?php echo $row['tax'];?></td>  
						</tr>
						<?php $cnt++; } ?>
					</tbody>
					<tfoot>
						<tr>
							<th>SR No</th>
				 			<th>Employee Name</th>
                            <th>Designation</th>
                            <th>Employee Code</th>
                            <th>Gross Pay</th>
                            <th>Professional Tax</th>
						</tr>
					</tfoot>
				  </table>
				</div>
			  </div>
			</div>
          </div>
         </div>
    </div>
<?php
    if(isset($_SESSION['delete'])) unset($_SESSION['delete']);
    if(isset($_SESSION['s_sa'])) unset($_SESSION['s_sa']);
    include'system/footer.php';
?>