<?php
// attendace-processing.php
session_start();
if(empty($_SESSION['branch'])) {
    header("Location: index.php");
    die();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Processing Salary</title>
    
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css">
    
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    
    <style>
        body {
            background-color: #f0f2f5; /* Slightly darker background for contrast */
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Roboto', sans-serif;
        }
        .card {
            width: 100%;
            max-width: 480px;
            border: none;
            box-shadow: 0 4px 20px rgba(0,0,0,0.08); /* Softer shadow */
            border-radius: 12px;
            background: #fff;
        }
        .status-icon {
            font-size: 4.5rem;
            margin-bottom: 1rem;
        }
        .spinner-border {
            width: 3.5rem;
            height: 3.5rem;
            border-width: 0.25em;
        }
        /* Enforce Blue Styling */
        .text-primary {
            color: #0d6efd !important;
        }
        .btn-primary {
            background-color: #0d6efd;
            border-color: #0d6efd;
        }
        .btn-primary:hover {
            background-color: #0b5ed7;
            border-color: #0a58ca;
        }
    </style>
</head>
<body>

<div class="card p-5 text-center" id="processingCard">
    <div class="mb-4">
        <div class="spinner-border text-primary" role="status">
            <span class="visually-hidden">Loading...</span>
        </div>
    </div>
    <h3 class="fw-bold text-primary">Generating Salary...</h3>
    <p class="text-muted mb-0">Please wait. Do not close this window.</p>
    <p class="small text-secondary mt-2">Processing attendance, taxes, and deductions.</p>
</div>

<div class="card p-5 text-center d-none" id="resultCard">
    <div class="mb-3" id="iconContainer"></div>
    <h3 class="fw-bold" id="resultTitle"></h3>
    <p class="text-muted" id="resultMessage"></p>
    <div class="mt-4" id="actionButton"></div>
</div>

<script>
    document.addEventListener("DOMContentLoaded", function() {
        // Trigger the backend immediately on load
        fetch('salary-generate.php', {
            method: 'GET',
            headers: {
                'Content-Type': 'application/json'
            }
        })
        .then(response => {
            // Handle HTTP errors
            if (!response.ok) {
                return response.text().then(text => {
                    try {
                        const json = JSON.parse(text);
                        throw new Error(json.message || "Server Error: " + response.statusText);
                    } catch (e) {
                        throw new Error("System Error (" + response.status + "): " + text);
                    }
                });
            }
            return response.json();
        })
        .then(data => {
            if (data.status === 'success') {
                showResult('success', 'Generation Complete!', data.message);
                
                // Auto-redirect to Gross Sheet
                setTimeout(() => {
                    window.location.href = 'gross-sheet.php'; // Updated to match your file structure
                }, 1500);
            } else {
                showResult('error', 'Generation Failed', data.message);
            }
        })
        .catch(error => {
            showResult('error', 'System Error', error.message);
        });
    });

    function showResult(type, title, message) {
        // Hide loading card
        document.getElementById('processingCard').classList.add('d-none');
        
        // Setup result card
        const resultCard = document.getElementById('resultCard');
        const iconContainer = document.getElementById('iconContainer');
        const actionButton = document.getElementById('actionButton');
        const titleEl = document.getElementById('resultTitle');
        
        resultCard.classList.remove('d-none');
        titleEl.innerText = title;
        document.getElementById('resultMessage').innerText = message;

        if (type === 'success') {
            // FIXED: Changed Green (success) to Blue (primary)
            iconContainer.innerHTML = '<i class="bi bi-check-circle-fill text-primary status-icon"></i>';
            titleEl.className = "fw-bold text-primary";
            actionButton.innerHTML = '<a href="gross-sheet.php" class="btn btn-primary px-5 py-2">View Gross Sheet</a>';
        } else {
            // Errors remain Red for semantic meaning
            iconContainer.innerHTML = '<i class="bi bi-x-circle-fill text-danger status-icon"></i>';
            titleEl.className = "fw-bold text-danger";
            actionButton.innerHTML = '<a href="gross-sheet.php" class="btn btn-secondary px-4">Go Back</a> <button onclick="location.reload()" class="btn btn-outline-danger px-4 ms-2">Try Again</button>';
        }
    }
</script>

</body>
</html>