<?php
session_start();
if(empty($_SESSION['branch']) || $_SESSION['branch'] == ''){
    header("Location: index.php");
    die();
} 

require_once 'system/conn.php';

// Previous month/year
$previousMonth = strtotime('first day of previous month');
$year  = date('Y', $previousMonth);
$month = date('m', $previousMonth);

$branch = $_SESSION['branch'];

// Fetch employees of branch
$stmtEmp = $conn->prepare("
    SELECT e_id, e_name, e_doj, bank_ac_no, uan_no 
    FROM emp_details 
    WHERE branch = ? AND status = 1
");
$stmtEmp->execute([$branch]);
$employees = $stmtEmp->fetchAll(PDO::FETCH_ASSOC);

if (!$employees) {
    echo "<h3 style='text-align:center; color:red;'>No employee salary record found for this branch and month.</h3>";
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Bulk Salary Slips</title>
<style type="text/css">
    @page { 
        size: A4; 
        margin: 10mm; /* Standard Print Margins */
    }

    body {
        margin: 0;
        padding: 0;
        font-family: Arial, sans-serif;
    }

    /* Exact Half-Page Container 
       A4 Height (297mm) - Margins (20mm) = 277mm Printable.
       277mm / 2 = ~138mm per slip.
    */
    .slip-container {
        height: 138mm; 
        width: 100%;
        display: flex;
        justify-content: flex-start; /* FORCE TOP ALIGNMENT */
        align-items: center;
        flex-direction: column;
        border-bottom: 1px dashed #999; /* Cut line */
        box-sizing: border-box;
        padding-top: 5mm; /* Small gap from top edge */
    }

    /* Remove cut line for the bottom slip */
    .slip-container.even-slip {
        border-bottom: none; 
    }

    /* Table Styling (Matches your requested size) */
    .salary-slip {
        width: 100%; 
        max-width: 700px; /* Locked width for consistency */
        border-collapse: collapse;
        font-size: 11px;
    }

    .salary-slip td,
    .salary-slip th {
        border: 1px solid #000;
        padding: 4px 6px; /* Optimized padding */
    }

    .green { 
        background:#c5e0b3; 
        font-weight:bold; 
        -webkit-print-color-adjust: exact; 
    }

    .center { text-align:center; }

    /* Buttons */
    .no-print { margin: 20px 0; text-align: center; }
    .btn { padding: 8px 20px; background: #007bff; color: white; border: none; border-radius: 4px; cursor: pointer; text-decoration: none;}
    .btn-back { background: #6c757d; }

    /* Print Specifics */
    @media print {
        .no-print { display: none !important; }
        body, html { height: 100%; }
        
        /* Force Page Break after every 2nd slip */
        .page-break {
            page-break-after: always;
            break-after: page;
            height: 0;
            display: block;
            clear: both;
        }
    }
</style>

<script>
function printSlip(){ window.print(); }
function goBack(){ window.history.back(); }
</script>
</head>
<body>

<div class="no-print">
    <button onclick="window.print()" class="btn">Print All Slips</button>
    <button onclick="window.close()" class="btn btn-back">Close</button>
</div>

<?php 
$counter = 0; 

foreach ($employees as $emp) {

    // Fetch salary
    $stmtSalary = $conn->prepare("
        SELECT name, designation, ac_no, attendance, gross_pay,
               pf, esic, advance, tax, deduction, net_pay
        FROM emp_salary
        WHERE emp_id = ? AND month = ? AND year = ? AND branch = ?
        LIMIT 1
    ");
    $stmtSalary->execute([ $emp['e_id'], $month, $year, $branch ]);
    $salary = $stmtSalary->fetch(PDO::FETCH_ASSOC);

    if (!$salary) continue; 

    // Fetch OT
    $stmtOT = $conn->prepare("
        SELECT ot_days, amount
        FROM ot_details
        WHERE emp_id = ? AND month = ? AND year = ? AND branch = ?
        LIMIT 1
    ");
    $stmtOT->execute([ $emp['e_id'], $month, $year, $branch ]);
    $ot = $stmtOT->fetch(PDO::FETCH_ASSOC);

    $otDays   = $ot['ot_days'] ?? 0;
    $otAmount = $ot['amount'] ?? 0;
    $totalSalary = $salary['net_pay'] + $otAmount;
    
    $counter++;
    $isEven = ($counter % 2 == 0); 
    ?>

    <div class="slip-container <?= $isEven ? 'even-slip' : '' ?>">
        
        <table class="salary-slip">
            <tbody>
                <tr>
                    <td colspan="4" class="green center" style="font-size: 13px;">UTKAL TEAM CARE PVT LTD</td>
                </tr>
                <tr>
                   <td colspan="3">
                        <div>
                             <p align="left" style="margin:0">
                                 <font face="Times New Roman, serif" size="3" style="font-size: 10pt">
                                    Plot No – 361, Ground Floor<br>
                                    Anuj Times Squre building, Rupali Squre<br>
                                    Bhubaneswar, Odisha-751007<br>
                                    Email:- info@utcpl.co.in
                                 </font>
                             </p>
                        </div>
                   </td>
                   <td class="center">
                        <img src="https://utcpl.co.in/images/logo-1.webp" height="50"> 
                   </td>
                </tr>
                <tr>
                    <td colspan="4" class="green">
                        Pay Slip For the Month : <?= date('F', mktime(0, 0, 0, (int)$month, 1)); ?> <?= $year ?>
                    </td>
                </tr>
                <tr>
                    <td>Employee ID</td><td><?= htmlspecialchars($emp['e_id']) ?></td>
                    <td>Bank A/C No</td><td><?= htmlspecialchars($salary['ac_no']) ?></td>
                </tr>
                <tr>
                    <td>Name</td><td><?= htmlspecialchars($salary['name']) ?></td>
                    <td>Working Days</td><td><?= $salary['attendance'] ?></td>
                </tr>
                <tr>
                    <td>Designation</td><td><?= htmlspecialchars($salary['designation']) ?></td>
                    <td>UAN</td><td><?= $emp['uan_no'] ?></td>
                </tr>
                <tr>
                    <td>DOJ</td><td colspan="3"><?= $emp['e_doj'] ?></td>
                </tr>
                <tr>
                    <td colspan="2" class="green">GROSS</td>
                    <td colspan="2" class="green">DEDUCTIONS</td>
                </tr>
                <tr><td colspan="2"></td><td>PF</td><td><?= $salary['pf'] ?></td></tr>
                <tr><td colspan="2"></td><td>ESIC</td><td><?= $salary['esic'] ?></td></tr>
                <tr><td colspan="2"></td><td>Advance</td><td><?= $salary['advance'] ?></td></tr>
                <tr><td colspan="2"></td><td>PT</td><td><?= $salary['tax'] ?></td></tr>
                <tr>
                    <td>GROSS PAY</td><td><?= $salary['gross_pay'] ?></td>
                    <td>DEDUCTIONS</td><td><?= $salary['deduction'] ?></td>
                </tr>
                <tr>
                    <td colspan="2"></td>
                    <td class="green">NET SALARY</td>
                    <td class="green"><?= $salary['net_pay'] ?></td>
                </tr>
                <tr>
                    <td>OT Days</td><td><?= $otDays ?></td>
                    <td>OT Salary</td><td><?= $otAmount ?></td>
                </tr>
                <tr>
                    <td colspan="2"></td>
                    <td class="green">TOTAL SALARY</td>
                    <td class="green"><?= $totalSalary ?></td>
                </tr>
            </tbody>
        </table>

    </div>

    <?php 
    // Force Page Break after every 2nd slip
    if ($isEven) {
        echo '<div class="page-break"></div>';
    }
    ?>

<?php } ?>

</body>
</html>