<?php
session_start();
if(empty($_SESSION['branch']) || $_SESSION['branch'] == ''){
    header("Location: index.php"); die();
}
require_once 'system/conn.php';

$year  = $_POST['year']  ?? '';
$month = $_POST['month'] ?? '';
$ename = $_POST['ename'] ?? '';
$type  = $_POST['salary_type'] ?? 'current'; 
$branch = $_SESSION['branch'];

// 1. DATA FETCHING LOGIC 
if ($type == 'current') {
    $salaryTable = 'emp_salary';
    $otTable     = 'ot_details';
} else {
    $salaryTable = 'prv_emp_salary';
    $otTable     = 'prv_ot_details';
}

// Fetch Employee Master Details
$stmtEmp = $conn->prepare("SELECT * FROM emp_details WHERE e_id = ? AND branch = ?");
$stmtEmp->execute([$ename, $branch]);
$empDetails = $stmtEmp->fetch(PDO::FETCH_ASSOC);

// Fetch Salary Record
$stmtSalary = $conn->prepare("SELECT * FROM `$salaryTable` WHERE emp_id = ? AND month = ? AND year = ? AND branch = ?");
$stmtSalary->execute([$ename, $month, $year, $branch]);
$salary = $stmtSalary->fetch(PDO::FETCH_ASSOC);

if (!$salary) {
    die("<h3 style='text-align:center; color:red; margin-top:50px;'>Salary Record Not Found.</h3>
         <p style='text-align:center;'>It seems no salary was generated for <b>$ename</b> in $month/$year in the <b>$type</b> records.</p>");
}

// Fetch OT Record
$stmtOT = $conn->prepare("SELECT * FROM `$otTable` WHERE emp_id = ? AND month = ? AND year = ? AND branch = ?");
$stmtOT->execute([$ename, $month, $year, $branch]);
$ot = $stmtOT->fetch(PDO::FETCH_ASSOC);

$otDays      = $ot['ot_days'] ?? 0;
$otAmount    = $ot['amount'] ?? 0;
$totalSalary = $salary['net_pay'] + $otAmount;
$monthName   = date('F', mktime(0, 0, 0, (int)$month, 1));
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Slip_<?= $ename ?>_<?= $month ?>_<?= $year ?></title>

<style>
    @page { 
        size: A4; 
        margin: 10mm; 
    }

    body {
        margin: 0;
        padding: 0;
        font-family: Arial, sans-serif;
    }

    /* EXACT HALF-PAGE CONTAINER (Matching Bulk Print) */
    .slip-container {
        height: 138mm; 
        width: 100%;
        display: flex;
        justify-content: flex-start; /* FORCE TOP ALIGNMENT */
        align-items: center;
        flex-direction: column;
        border-bottom: 1px dashed #999; /* The cut line */
        box-sizing: border-box;
        padding-top: 5mm; /* Small gap from top edge */
    }

    /* Table Styling */
    .salary-slip {
        width: 100%; 
        max-width: 700px; 
        border-collapse: collapse;
        font-size: 11px;
    }

    .salary-slip td,
    .salary-slip th {
        border: 1px solid #000;
        padding: 4px 6px; 
    }

    .green { 
        background:#c5e0b3; 
        font-weight:bold; 
        -webkit-print-color-adjust: exact; 
    }

    .center { text-align:center; }

    /* Buttons */
    .no-print { 
        margin: 20px 0; 
        text-align: center; 
        display: flex; 
        justify-content: center; 
        gap: 15px; 
    }
    .btn { padding: 8px 25px; background: #007bff; color: white; border: none; border-radius: 4px; font-size: 14px; text-decoration: none; cursor: pointer;}
    .btn-back { background: #6c757d; }

    @media print {
        .no-print { display: none !important; }
        body, html { height: 100%; }
    }
</style>
</head>

<body>

<div class="no-print">
    <button onclick="window.print()" class="btn">Print Slip</button>
    <button onclick="window.close()" class="btn btn-back">Close</button>
</div>

<div class="slip-container">
    <table class="salary-slip">
        <tbody>
            <tr>
                <td colspan="4" class="green center" style="font-size: 13px;">UTKAL TEAM CARE PVT LTD</td>
            </tr>
            <tr>
               <td colspan="3">
                    <div>
                         <p align="left" style="margin:0">
                             <font face="Times New Roman, serif" size="3" style="font-size: 10pt">
                                <?= defined('COMPANY_ADDR') ? COMPANY_ADDR : 'Address Not Defined' ?>
                             </font>
                         </p>
                    </div>
               </td>
               <td class="center">
                    <img src="<?= defined('COMPANY_LOGO') ? COMPANY_LOGO : '' ?>" height="50"> 
               </td>
            </tr>
            <tr>
                <td colspan="4" class="green">
                    Pay Slip For the Month : <?= $monthName ?> <?= $year ?>
                </td>
            </tr>
            <tr>
                <td>Employee ID</td><td><?= htmlspecialchars($ename) ?></td>
                <td>Bank A/C No</td><td><?= htmlspecialchars($salary['ac_no']) ?></td>
            </tr>
            <tr>
                <td>Name</td><td><?= htmlspecialchars($salary['name']) ?></td>
                <td>Working Days</td><td><?= $salary['attendance'] ?></td>
            </tr>
            <tr>
                <td>Designation</td><td><?= htmlspecialchars($salary['designation']) ?></td>
                <td>UAN</td><td><?= $empDetails['uan_no'] ?? '' ?></td>
            </tr>
            <tr>
                <td>DOJ</td><td colspan="3"><?= $empDetails['e_doj'] ?? '' ?></td>
            </tr>
            <tr>
                <td colspan="2" class="green">GROSS</td>
                <td colspan="2" class="green">DEDUCTIONS</td>
            </tr>
            <tr><td colspan="2"></td><td>PF</td><td><?= $salary['pf'] ?></td></tr>
            <tr><td colspan="2"></td><td>ESIC</td><td><?= $salary['esic'] ?></td></tr>
            <tr><td colspan="2"></td><td>Advance</td><td><?= $salary['advance'] ?></td></tr>
            <tr><td colspan="2"></td><td>PT</td><td><?= $salary['tax'] ?></td></tr>
            <tr>
                <td>GROSS PAY</td><td><?= $salary['gross_pay'] ?></td>
                <td>DEDUCTIONS</td><td><?= $salary['deduction'] ?></td>
            </tr>
            <tr>
                <td colspan="2"></td>
                <td class="green">NET SALARY</td>
                <td class="green"><?= $salary['net_pay'] ?></td>
            </tr>
            <tr>
                <td>OT Days</td><td><?= $otDays ?></td>
                <td>OT Salary</td><td><?= $otAmount ?></td>
            </tr>
            <tr>
                <td colspan="2"></td>
                <td class="green">TOTAL SALARY</td>
                <td class="green"><?= $totalSalary ?></td>
            </tr>
        </tbody>
    </table>
</div>

</body>
</html>