<?php 
  session_start();
  // 1. Security Check
  if(empty($_SESSION['branch']) || $_SESSION['branch'] == ''){
    header("Location: index.php");
    die();
  }
  
  require_once 'system/conn.php';

  // 2. Date Calculation (Previous Month)
  // Example: If today is Feb 2026, we process Jan 2026 salary
  $targetDate = strtotime("first day of last month");
  $monthNum = date('m', $targetDate); // 01
  $monthName = date('F', $targetDate); // January
  $year = date('Y', $targetDate); // 2026
  
  $branch_id = $_SESSION['branch'];

  // 3. FETCH COUNTS (Using PDO)
  
  // A. Employees with Missing Mobile Numbers
  $sql_mobile = "SELECT COUNT(*) FROM emp_details 
                 WHERE (mobile_num = 'NA' OR mobile_num = '' OR mobile_num IS NULL) 
                 AND branch = :branch AND status = 1";
  $stmt = $conn->prepare($sql_mobile);
  $stmt->execute([':branch' => $branch_id]);
  $missing_mobile_count = $stmt->fetchColumn();

  // B. Employees Eligible for Salary (Gross Salary Generated)
  $sql_salary = "SELECT COUNT(*) FROM emp_salary 
                 WHERE month = :m AND year = :y AND branch = :branch";
  $stmt = $conn->prepare($sql_salary);
  $stmt->execute([':m' => $monthNum, ':y' => $year, ':branch' => $branch_id]);
  $salary_count = $stmt->fetchColumn();

  // C. Employees Eligible for OT
  $sql_ot = "SELECT COUNT(*) FROM ot_details 
             WHERE month = :m AND year = :y AND branch = :branch";
  $stmt = $conn->prepare($sql_ot);
  $stmt->execute([':m' => $monthNum, ':y' => $year, ':branch' => $branch_id]);
  $ot_count = $stmt->fetchColumn();
?>
<!doctype html>
<html lang="en" class="semi-dark">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <link href="assets/css/pace.min.css" rel="stylesheet" />
    <script src="assets/js/pace.min.js"></script>
    <link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
    <link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
    <link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />

    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/bootstrap-extended.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
    <link href="assets/css/icons.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">

    <link href="assets/css/dark-theme.css" rel="stylesheet" />
    <link href="assets/css/semi-dark.css" rel="stylesheet" />
    <link href="assets/css/header-colors.css" rel="stylesheet" />
    <script src="assets/js/jquery.min.js"></script>

    <title>SMS Notification Center</title>
    
    <style>
        .card {
            border: none;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }
        .icon-box {
            width: 48px;
            height: 48px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 10px;
            font-size: 24px;
        }
    </style>
  </head>
  <body>
    
  <div class="wrapper">
    <?php include'system/header.php'?>

    <div class="page-content-wrapper">
      <div class="page-content">

        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
          <div class="breadcrumb-title pe-3">SMS Center</div>
          <div class="ps-3 border-start">
              <span class="text-secondary">Processing Period: <strong><?php echo "$monthName $year"; ?></strong></span>
          </div>
        </div>

        <div class="row">
          <div class="col-xl-8 mx-auto">
             
             <div class="card border-top border-0 border-4 border-primary">
               <div class="card-body p-4">

                <div class="d-flex align-items-center justify-content-between mb-4">
                    <div>
                        <h5 class="mb-0 text-primary">Send Salary Slips</h5>
                        <p class="mb-0 text-secondary">Notify employees via SMS for the selected month.</p>
                    </div>
                    <div class="fs-1 text-primary"><i class="bi bi-chat-square-text"></i></div>
                </div>
                
                <hr class="mb-4" />

                <?php if($missing_mobile_count > 0): ?>
                <div class="alert alert-danger border-0 bg-danger alert-dismissible fade show py-2">
                    <div class="d-flex align-items-center">
                        <div class="fs-3 text-white"><i class="bi bi-exclamation-triangle-fill"></i></div>
                        <div class="ms-3">
                            <div class="text-white fw-bold">Missing Contact Information</div>
                            <div class="text-white small">
                                There are <strong><?php echo $missing_mobile_count; ?></strong> employees with missing mobile numbers. 
                                SMS will not be sent to them. Please update their profiles.
                            </div>
                        </div>
                    </div>
                </div>
                <?php else: ?>
                <div class="alert alert-success border-0 bg-success alert-dismissible fade show py-2">
                    <div class="d-flex align-items-center">
                        <div class="fs-3 text-white"><i class="bi bi-check-circle-fill"></i></div>
                        <div class="ms-3">
                            <div class="text-white">All active employees have valid mobile numbers.</div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <div class="row g-4 mt-2">
                    
                    <div class="col-md-6">
                        <div class="p-3 border rounded bg-light d-flex align-items-center justify-content-between">
                            <div>
                                <p class="mb-0 text-secondary small text-uppercase fw-bold">Eligible for Salary</p>
                                <h4 class="my-1 text-primary"><?php echo $salary_count; ?></h4>
                                <span class="small text-muted">Employees generated</span>
                            </div>
                            <div class="icon-box bg-primary text-white">
                                <i class="bi bi-wallet2"></i>
                            </div>
                        </div>
                        <div class="mt-3">
                            <a href="sms-send.php" class="btn btn-primary w-100 py-2 <?php echo ($salary_count == 0) ? 'disabled' : ''; ?>">
                                <i class="bi bi-send me-2"></i>Send Salary SMS
                            </a>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="p-3 border rounded bg-light d-flex align-items-center justify-content-between">
                            <div>
                                <p class="mb-0 text-secondary small text-uppercase fw-bold">Eligible for OT</p>
                                <h4 class="my-1 text-warning"><?php echo $ot_count; ?></h4>
                                <span class="small text-muted">Employees with OT</span>
                            </div>
                            <div class="icon-box bg-warning text-dark">
                                <i class="bi bi-stopwatch"></i>
                            </div>
                        </div>
                        <div class="mt-3">
                            <a href="sms-ot-process.php" class="btn btn-warning w-100 py-2 <?php echo ($ot_count == 0) ? 'disabled' : ''; ?>">
                                <i class="bi bi-send me-2"></i>Send OT SMS
                            </a>
                        </div>
                    </div>

                </div>
                
                <div class="mt-4 text-center">
                    <small class="text-muted fst-italic">
                        <i class="bi bi-info-circle me-1"></i> 
                        Please verify salary data before clicking send. This action cannot be undone.
                    </small>
                </div>

               </div>
             </div>
          </div>
        </div>

      </div>
    </div>

<?php include'system/footer.php'?>