<?php
// 1. Fetch Current Branch Name
$branchName = "Unknown Branch";
if (isset($_SESSION['branch'])) {
    $stmt = $conn->prepare("SELECT name FROM branch WHERE id = ?");
    $stmt->execute([$_SESSION['branch']]);
    $branchRow = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($branchRow) {
        $branchName = $branchRow['name'];
    }
}

// 2. Fetch All Branches for Current Username (For the Switcher)
$myBranches = [];
if(isset($_SESSION['username'])){
    $stmtB = $conn->prepare("SELECT id, name FROM branch WHERE username = ? AND status = 1 ORDER BY name ASC");
    $stmtB->execute([$_SESSION['username']]);
    $myBranches = $stmtB->fetchAll(PDO::FETCH_ASSOC);
}
?>

<aside class="sidebar-wrapper" data-simplebar="true">
    <div class="sidebar-header">
        <div>
            <img src="https://utcpl.co.in/images/logo-1.webp" class="logo-icon bg-white rounded-2 border-2 border" alt="logo icon" style="height: 65px;">
        </div>
        <div class="toggle-icon ms-auto">
            <ion-icon name="menu-sharp"></ion-icon>
        </div>
    </div>
    
    <ul class="metismenu" id="menu">
        <li>
            <a href="home">
                <div class="parent-icon"><i class="bi bi-house-door"></i></div>
                <div class="menu-title">Dashboard</div>
            </a>
        </li>
        
        <li>
            <a href="javascript:;" class="has-arrow">
                <div class="parent-icon"><i class="bi bi-list-ul"></i></div>
                <div class="menu-title">Employee</div>
            </a>
            <ul>
                <li> <a href="add-employee"><i class="bi bi-circle"></i>Add Employee</a> </li>
                <li> <a href="all-employees"><i class="bi bi-circle"></i>All Employees</a> </li>
                <li> <a href="new-employees"><i class="bi bi-circle"></i>New Join Employees</a> </li>
                <li> <a href="left-employees"><i class="bi bi-circle"></i>Left Employees</a> </li>
                <li> <a href="rejoin-employees"><i class="bi bi-circle"></i>Re-Join Employees</a> </li>
                <li> <a href="salary-slip"><i class="bi bi-circle"></i>Salary Slip Download</a> </li>
                <li> <a href="emp-salary-history"><i class="bi bi-circle"></i>Salary History</a> </li>
                <li> <a href="branch-transfer"><i class="bi bi-circle"></i>Employee Transfer (Copy)</a> </li>
                <li> <a href="experience"><i class="bi bi-circle"></i>Experience Count</a> </li>
            </ul>
        </li>
        
        <li>
            <a href="javascript:;" class="has-arrow">
                <div class="parent-icon"><i class="bi bi-list-ul"></i></div>
                <div class="menu-title">Current Salary</div>
            </a>
            <ul>
                <li> <a href="gross-sheet"><i class="bi bi-circle"></i>Gross Sheet</a> </li>
                <li> <a href="bank-sheet"><i class="bi bi-circle"></i>Bank Sheet</a> </li>
                <li> <a href="cheque-sheet"><i class="bi bi-circle"></i>Cheque Sheet</a> </li>
                <li> <a href="hold-sheet"><i class="bi bi-circle"></i>Hold Sheet</a> </li>
                <li> <a href="professional-tax"><i class="bi bi-circle"></i>PT Sheet</a> </li>
            </ul>
        </li>

        <li>
            <a href="javascript:;" class="has-arrow">
                <div class="parent-icon"><i class="bi bi-list-ul"></i></div>
                <div class="menu-title">Current OT Salary</div>
            </a>
            <ul>
                <li> <a href="ot-gross-sheet"><i class="bi bi-circle"></i>Gross Sheet</a> </li>
                <li> <a href="ot-bank-sheet"><i class="bi bi-circle"></i>Bank sheet</a> </li>
                <li> <a href="ot-cheque-sheet"><i class="bi bi-circle"></i>Cheque Sheet</a> </li>
                <li> <a href="ot-hold-sheet"><i class="bi bi-circle"></i>Hold Sheet</a> </li>
            </ul>
        </li>

        <li>
            <a href="javascript:;" class="has-arrow">
                <div class="parent-icon"><i class="bi bi-list-ul"></i></div>
                <div class="menu-title">Old Salary Data</div>
            </a>
            <ul>
                <li> <a href="previous-salary.php"><i class="bi bi-circle"></i>Previous Salary</a> </li>
                <li> <a href="previous-attendance.php"><i class="bi bi-circle"></i>Previous Attendance</a> </li>
            </ul>
        </li>

        <li>
            <a href="javascript:;" class="has-arrow">
                <div class="parent-icon"><i class="bi bi-list-ul"></i></div>
                <div class="menu-title">Attendance</div>
            </a>
            <ul>
                <li> <a href="add-attendance"><i class="bi bi-circle"></i>Add Attendance</a> </li>
                <li> <a href="current-attendance"><i class="bi bi-circle"></i>Current Attendance</a> </li>
                <li> <a href="previous-attendance"><i class="bi bi-circle"></i>Old Attendance</a> </li>
            </ul>
        </li>

        <li>
            <a href="javascript:;" class="has-arrow">
                <div class="parent-icon"><i class="bi bi-list-ul"></i></div>
                <div class="menu-title">Advance</div>
            </a>
            <ul>
                <li> <a href="advance-issue"><i class="bi bi-circle"></i>Issue Advance</a> </li>
                <li> <a href="advance-view"><i class="bi bi-circle"></i>View All Advance</a> </li>
                <li> <a href="advance-emp-ledger"><i class="bi bi-circle"></i>Emp Advance History</a> </li>
            </ul>
        </li>

        <li>
            <a href="javascript:;" class="has-arrow">
                <div class="parent-icon"><i class="bi bi-list-ul"></i></div>
                <div class="menu-title">Payment Record</div>
            </a>
            <ul>
                <li><a href="payment-entry"><i class="bi bi-circle"></i>Payment Entry</a> </li>
                <li><a href="individual-payment-entry"><i class="bi bi-circle"></i>Individual Payment Entry</a> </li>
                <li><a href="payment-data"><i class="bi bi-circle"></i>View Current Payment</a> </li>
                <li><a href="prv-payment-data"><i class="bi bi-circle"></i>View Old Payment</a> </li>
                <li><a href="reverse-payment-entry"><i class="bi bi-circle"></i>Reverse Payment Entry</a> </li>
                <li><a href="reverse-payment-data"><i class="bi bi-circle"></i>View Current rev Payment</a> </li>
                <li><a href="prv-reverse-payment"><i class="bi bi-circle"></i>View Old rev Payment</a> </li>
            </ul>
        </li>

        <li>
            <a href="javascript:;" class="has-arrow">
                <div class="parent-icon"><i class="bi bi-list-ul"></i></div>
                <div class="menu-title">Settings</div>
            </a>
            <ul>
                <li> <a href="salary-sms"><i class="bi bi-circle"></i>Send Salary SMS</a> </li>
                <li> <a href="archive"><i class="bi bi-circle"></i>Archive Old Data</a> </li>
                <li> <a href="site-list"><i class="bi bi-circle"></i>Site Management</a> </li>
            </ul>
        </li>
    </ul>
</aside>

<header class="top-header">
    <nav class="navbar navbar-expand gap-3">
        <div class="mobile-menu-button">
            <i class="bi bi-list"></i>
        </div>
        
        <div class="top-navbar-center ms-auto">
            <div class="btn-group">
                <button type="button" class="btn btn-light dropdown-toggle px-4 border shadow-sm" data-bs-toggle="dropdown" aria-expanded="false">
                    <b><i class="bi bi-geo-alt-fill text-primary"></i> <?php echo htmlspecialchars($branchName); ?></b>
                </button>
                <ul class="dropdown-menu dropdown-menu-center" style="max-height: 400px; overflow-y: auto;">
                    <li><h6 class="dropdown-header">Switch Branch</h6></li>
                    <li><hr class="dropdown-divider"></li>
                    
                    <?php if(count($myBranches) > 0): ?>
                        <?php foreach($myBranches as $br): ?>
                            <?php 
                                // Highlight current branch
                                $isActive = ($br['id'] == $_SESSION['branch']);
                                $activeClass = $isActive ? 'active bg-primary text-white' : ''; 
                                $icon = $isActive ? 'check-circle-fill' : 'building';
                            ?>
                            <li>
                                <a class="dropdown-item <?php echo $activeClass; ?>" href="system/switch-branch.php?id=<?php echo $br['id']; ?>">
                                    <i class="bi bi-<?php echo $icon; ?> me-2"></i> <?php echo htmlspecialchars($br['name']); ?>
                                </a>
                            </li>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <li><span class="dropdown-item text-muted">No other branches found</span></li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
        
        <div class="top-navbar-right ms-auto">
            <ul class="navbar-nav align-items-center">
                <li class="nav-item dropdown dropdown-user-setting">
                    <a class="nav-link dropdown-toggle dropdown-toggle-nocaret" href="javascript:;" data-bs-toggle="dropdown">
                        <div class="user-setting">
                            <img src="assets/images/user.png" class="user-img bg-white rounded-circle border-2 border" alt="">
                        </div>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li>
                            <a class="dropdown-item" href="javascript:;">
                                <div class="d-flex flex-row align-items-center gap-2">
                                    <img src="assets/images/user.png" alt="U" class="bg-white rounded-circle border-2 border" width="64" height="64">
                                    <div class="">
                                        <h6 class="mb-0 dropdown-user-name">
                                            <?php echo htmlspecialchars($branchName); ?>
                                        </h6>
                                    </div>
                                </div>
                            </a>
                        </li>
                        <li><hr class="dropdown-divider"></li>
                        <li>
                            <a class="dropdown-item" href="chnge-password">
                                <div class="d-flex align-items-center">
                                    <div class=""><ion-icon name="speedometer-outline"></ion-icon></div>
                                    <div class="ms-3"><span>Change Password</span></div>
                                </div>
                            </a>
                        </li>
                        <li><hr class="dropdown-divider"></li>
                        <li>
                            <a class="dropdown-item" href="logout">
                                <div class="d-flex align-items-center">
                                    <div class=""><ion-icon name="log-out-outline"></ion-icon></div>
                                    <div class="ms-3"><span>Logout</span></div>
                                </div>
                            </a>
                        </li>
                    </ul>
                </li>
            </ul>
        </div>
    </nav>
</header>